<div class="flex flex-col md:flex-row md:h-screen">
    @include('components.basics.toast')

    <!-- Left Column - Form (Scrollable) -->
    <div class="w-full md:w-1/3 md:overflow-y-auto flex items-center justify-center px-4 py-8 md:px-8 relative min-h-screen">

        <div class="w-full max-w-md px-8">

            {{-- <img src="{{ asset('images/ango-logo-black.png') }}" alt="Logo Black" class="w-24"> --}}

            <x-basics.section-title title="Bienvenue sur Ango" Subtitle="Entrez vos identifiants pour accéder à votre compte." />

            <form wire:submit.prevent="login" class="space-y-6 mt-6 mb-6">
                @csrf
                <div class="mb-4">
                    <x-basics.input type="email" name="email" label="Email"
                        placeholder="Email" wire:model.live.debounce.1000ms="email"
                        :error="$errors->first('email')" />
                </div>

                <div class="mb-4">
                    <x-basics.input type="password" name="password" label="Mot de passe" placeholder="Mot de passe"
                        showPasswordToggle wire:model="password" :error="$errors->first('password')" />
                </div>

                <!-- Remember Me Checkbox -->
                <div class="mb-4">
                    <label class="flex items-center">
                        <input type="checkbox" wire:model="remember" class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                        <span class="ml-2 text-sm text-gray-600">Se souvenir de moi</span>
                    </label>
                </div>

                <x-basics.button :disabled="!$can_login || $loading" type="submit" class="w-full" wireTarget="login">
                    <span wire:loading.remove>Se connecter</span>
                    <span wire:loading wire:target="login">Connexion en cours...</span>
                </x-basics.button>
            </form>

            <!-- Links -->
            <div class="flex flex-col md:flex-row justify-between space-y-2 mt-4">
                <x-basics.link size="sm" href="{{ route('password.request') }}" wire:navigate>
                    Mot de passe oublié?
                </x-basics.link>


                <x-basics.link size="sm" href="{{ route('register') }}" wire:navigate>
                    Créer un compte Ango
                </x-basics.link>
            </div>

        </div>

        <footer class="absolute bottom-0 left-0 right-0">
            <div class="flex justify-center items-center">
                <p class="text-sm text-gray-500">Copyright © 2025 Ango. Tous droits réservés.</p>
            </div>
        </footer>

    </div>

    <!-- Right Column - Background Image (Hidden on mobile, Sticky on desktop) -->
    <div class="hidden md:flex md:sticky md:top-0 md:w-2/3 md:h-screen items-center justify-center">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat bg-black/70 shad" style="background-image: url('{{ asset('images/bg-login.png') }}');">
        </div>
    </div>

</div>