<div class="flex flex-col md:flex-row md:h-screen">
    @include('components.basics.toast')

    <!-- Left Column - Background Image (Hidden on mobile, Sticky on desktop) -->
    <div class="hidden md:flex md:sticky md:top-0 md:w-2/3 md:h-screen items-center justify-center">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat bg-black/70"
            style="background-image: url('{{ asset('images/bg-login.png') }}');">
        </div>
    </div>

    <!-- Right Column - Form (Scrollable) -->
    <div class="w-full md:w-1/3 md:overflow-y-auto flex items-center justify-center px-4 py-8 md:px-8 relative min-h-screen">

        <div class="w-full max-w-md px-8">
            <x-basics.section-title title="Vérification OTP" Subtitle="Entrez le code reçu par email." />

            <form wire:submit.prevent="verify" class="space-y-6 mt-6">
                <x-basics.input type="text" name="otp" label="Code OTP" placeholder="****" maxLength="4"
                    wire:model="otp" />

                <x-basics.button type="submit" class="w-full" wireTarget="verify">
                    <span wire:loading.remove wire:target="verify">Vérifier</span>
                    <span wire:loading wire:target="verify">Vérification...</span>
                </x-basics.button>
            </form>

            <div class="mt-4 flex items-center justify-between">
                <x-auth.logout-link />
                <div class="flex items-center min-h-11">
                    <button
                        type="button"
                        wire:click="resend"
                        wire:loading.attr="disabled"
                        wire:target="resend"
                        class="text-sm text-indigo-600 font-semibold hover:underline disabled:text-gray-400 disabled:cursor-not-allowed"
                    >
                        <span wire:loading.remove wire:target="resend" wire:poll.1s="updateFormattedRemaining">
                            @if($formattedRemaining)
                                Prochain code dans {{ $formattedRemaining }}
                            @else
                                Renvoyer le code
                            @endif
                        </span>
                        <span wire:loading wire:target="resend" class="flex items-center gap-2">
                            <x-basics.spinner size="xs" class="animate-spin" />
                            Envoi...
                        </span>
                    </button>
                </div>
            </div>
        </div>

        <footer class="absolute bottom-0 left-0 right-0">
            <div class="flex justify-center items-center">
                <p class="text-sm text-gray-500">Copyright © 2025 Ango. Tous droits réservés.</p>
            </div>
        </footer>

    </div>

</div>
