<div class="flex flex-col md:flex-row md:min-h-screen">
    @include('components.basics.toast')

    <!-- Left Column - Background Image (Hidden on mobile, Sticky on desktop) -->
    <div
        class="hidden md:flex md:sticky md:top-0 md:w-2/3 md:h-screen items-center justify-center order-1 md:order-none">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat bg-black/70"
            style="background-image: url('{{ asset('images/bg-login.png') }}');">
        </div>
    </div>

    <!-- Right Column - Form (Scrollable) -->
    <div class="w-full md:w-1/3 md:overflow-y-auto flex items-center justify-center px-4 py-8 md:px-8 relative order-2 md:order-none min-h-screen"
        x-data="{ showWarningModal: false }">

        <div class="w-full max-w-md px-8">
            <form wire:submit.prevent="register" class="mt-6">

                <x-basics.section-title title="Créer un compte" Subtitle="Complétez les informations ci-dessous." class="mb-6" />

                @csrf
                <x-basics.input class="mb-4" type="text" name="firstname" label="Prénom" placeholder="Votre prénom"
                    wire:model.live="firstname" :error="$errors->first('firstname')" />
                <x-basics.input class="mb-4" type="text" name="lastname" label="Nom" placeholder="Votre nom"
                    wire:model.live="lastname" :error="$errors->first('lastname')" />

                <x-basics.input class="mb-4" type="email" name="email" label="Email" placeholder="Votre email"
                    wire:model.live="email" :error="$errors->first('email')" />

                <x-basics.input class="mb-4" type="text" name="merchant_name" label="Nom de l'établissement"
                    placeholder="Ex: Pharmacie Saint-Joseph" wire:model.live="merchant_name" :error="$errors->first('merchant_name')" />

                <x-basics.input class="mb-4" type="password" name="password" label="Mot de passe"
                    placeholder="Mot de passe" showPasswordToggle wire:model.live="password" :error="$errors->first('password')" />


                <x-basics.button type="button" class="w-full" @click="showWarningModal = true" :disabled="!$canRegister">
                    <span>S'inscrire</span>
                </x-basics.button>

                <!-- Warning Modal for Database Populated -->
                <div>
                    <x-basics.modal show="showWarningModal" title="Création de compte" description="Création de compte pour un nouvel établissement"
                        size="md" canClose="true">

                        <div class="space-y-4">
                            <p class="text-sm text-gray-600">
                                Vous êtes sur le point de créer un <strong>nouvel établissement</strong>
                                (<strong>{{ $merchant_name }}</strong>).
                            </p>

                            <div class="p-4 bg-red-50 border border-red-200 rounded-lg">
                                <p class="text-sm font-semibold text-red-600 mb-2">
                                    Si vous créez un compte pour un nouvel établissement, toutes les données liées à un ancien établissement seront supprimées :
                                </p>
                                <ul class="text-sm text-gray-700 list-disc list-inside space-y-1">
                                    <li>Comptes utilisateurs</li>
                                    <li>Produits et inventaire</li>
                                    <li>Clients et fournisseurs</li>
                                    <li>Ventes et achats</li>
                                    <li>Toutes les autres données</li>
                                </ul>
                            </div>

                            <p class="text-sm font-semibold text-gray-800">
                                Voulez-vous vraiment continuer ?
                            </p>
                        </div>

                        <x-slot:footer>
                            <div class="flex gap-3">
                                <x-basics.button variant="danger" class="flex-1 flex align-items-center" wire:click="register" :disabled="$loading">
                                    <span wire:loading.remove>Oui, continuer</span>
                                    <span wire:loading wire:target="register">
                                        <x-basics.spinner size="sm" />
                                        <span class="ml-2">Création en cours...</span>
                                    </span>
                                </x-basics.button>
                            </div>
                        </x-slot:footer>
                    </x-basics.modal>
                </div>

                <div class="mt-4">
                    <x-basics.link size="sm" href="{{ route('login') }}" wire:navigate>
                        Déjà un compte ? Se connecter
                    </x-basics.link>
                </div>

            </form>
        </div>



        <footer class="absolute bottom-0 left-0 right-0">
            <div class="flex justify-center items-center">
                <p class="text-sm text-gray-500">Copyright © 2025 Ango. Tous droits réservés.</p>
            </div>
        </footer>

    </div>

</div>
