<div class="container mx-auto space-y-6">

    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb title="Modifier la catégorie" :items="[
        'Catégories' => route('categories.index'),
        $category->name => route('categories.show', $category),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.categories.dropdown :category="$category" />
        </x-slot>
    </x-dashboard.breadcrumb>



    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Edit Form -->
            <x-basics.card title="Modifier la catégorie" subtitle="Modifiez les informations de la catégorie">
                <x-slot name="action">
                    <x-basics.flash :model="'success'" :timeout="3000"/>
                </x-slot>

                <form wire:submit.prevent="save" class="space-y-4">
                    <div>
                        <x-basics.input wire:model.defer="name" name="name" label="Nom de la catégorie"
                            placeholder="Ex. Antibiotiques" :error="$errors->first('name')" required />
                    </div>

                    <div>
                        <x-basics.textarea wire:model.defer="description" name="description" label="Description"
                            placeholder="Description de la catégorie (optionnel)" :error="$errors->first('description')"
                            rows="3" />
                    </div>

                    @slot('footer')
                        <x-basics.button type="button" class="w-full" :disabled="!$can_save || $loading" leftIcon="floppy-disk" wire:click="save">
                            @if ($loading)
                                Enregistrement...
                            @else
                                Enregistrer les modifications
                            @endif
                        </x-basics.button>
                    @endslot
                </form>
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.categories.sidebar :category="$category" />
        </div>
    </div>
</div>
