<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Conversations' => null,
    ]" />

    @if ($errorMessage)
        <x-basics.alert class="mt-6" :type="$offlineMode ? 'warning' : 'danger'" :message="$errorMessage" />
    @endif

    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form wire:submit.prevent="refreshConversations" class="flex flex-wrap gap-4 items-end">
            <div class="flex-1 min-w-[220px]">
                <x-basics.input name="search" label="Rechercher" placeholder="Nom du client"
                    wire:model.live.debounce.500ms="search" mb="0" />
            </div>

            <div class="flex-none min-w-[150px]">
                <x-basics.select name="perPage" label="Éléments par page" :options="$perPageOptions" optionLabel="label"
                    optionValue="value" wire:model="perPage" mb="0" />
            </div>

            <div class="flex gap-2 flex-none">
                <x-basics.button type="submit" wire:loading.attr="disabled">
                    <i class="ph ph-arrows-clockwise mr-2"></i>
                    Actualiser
                </x-basics.button>

                <x-basics.button type="button" variant="outline" wire:click="resetFilters"
                    wire:loading.attr="disabled">
                    <i class="ph ph-arrow-counter-clockwise mr-2"></i>
                    Réinitialiser
                </x-basics.button>
            </div>
        </form>
    </div>

    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow relative">
        <div wire:loading.flex class="absolute inset-0 bg-white/70 backdrop-blur-sm z-10 items-center justify-center">
            <x-basics.spinner size="lg" text="Chargement des conversations..." />
        </div>

        <div class="p-4 border-b flex flex-col md:flex-row md:items-center md:justify-between gap-2">
            <div>
                <h4 class="font-semibold text-gray-800">Liste des conversations</h4>
            </div>
            <div class="text-sm text-gray-500">
                {{ $conversations->total() }} résultat{{ $conversations->total() > 1 ? 's' : '' }}
            </div>
        </div>

        <div class="overflow-x-auto">
            @if ($conversations->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr class="text-left text-gray-700 font-medium">
                            <th class="p-3 w-10">#</th>
                            <th class="p-3">Client</th>
                            <th class="p-3">Dernier message</th>
                            <th class="p-3 text-center">Non lus</th>
                            <th class="p-3">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($conversations as $conversation)
                            <tr class="border-t hover:bg-gray-50 transition-colors">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($conversations->currentPage() - 1) * $conversations->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('conversations.show', $conversation['slug']) }}"
                                        wire:navigate size="md">
                                        {{ $conversation['client_name'] ?? ($conversation['customer_name'] ?? 'Client inconnu') }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $conversation['last_message_body'] ?? 'Aucun message' }}
                                </td>
                                <td class="px-3 py-2 text-center">
                                    <span
                                        class="inline-flex items-center justify-center px-2 py-0.5 rounded-full text-xs font-medium {{ $conversation['unread_count'] > 0 ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-600' }}">
                                        {{ $conversation['unread_count'] }}
                                    </span>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    @php
                                        $createdAt = $conversation['created_at'] ?? ($conversation->created_at ?? null);
                                        if (is_string($createdAt)) {
                                            $createdAt = \Carbon\Carbon::parse($createdAt);
                                        }
                                    @endphp
                                    {{ $createdAt ? $createdAt->format('d/m/Y H:i') : '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">

                    @if ($offlineMode)
                        <div class="text-gray-500">
                            <i class="ph ph-wifi-slash text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Mode hors ligne</p>
                            <p class="text-sm">
                                Vous ne pouvez pas voir les conversations car vous êtes hors ligne. Veuillez vous
                                connecter à internet pour accéder aux conversations.
                            </p>
                        </div>
                    @elseif ($errorMessage)
                        <div class="text-gray-500">
                            <i class="ph ph-chat-circle text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Erreur de récupération</p>
                            <p class="text-sm">
                                {{ $errorMessage }}
                            </p>
                            <p class="text-xs mt-2 text-gray-400">
                                Si le problème persiste, vérifiez votre connexion internet et réessayez.
                            </p>
                        </div>
                    @else
                        <div class="text-gray-500">
                            <i class="ph ph-chat-circle text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune conversation trouvée</p>
                            <p class="text-sm">
                                Aucune conversation n'est disponible pour le moment. Les conversations apparaîtront ici
                                lorsqu'elles seront créées.
                            </p>
                        </div>
                    @endif

                </div>
            @endif
        </div>

        @if ($conversations->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $conversations->withQueryString()->links() }}
            </div>
        @endif
    </div>
</div>
