<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Clients' => route('customers.index'),
        $customer->name => route('customers.show', $customer),
        'Dettes' => null,
    ]" />

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('customers.debts.index', $customer) }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher..." placeholder="Numéro de vente..."
                    value="{{ request('search') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statusOptions" optionLabel="label" optionValue="value"
                    value="{{ request('status') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.input name="date_from" label="Date de début" type="date"
                    value="{{ request('date_from') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.input name="date_to" label="Date de fin" type="date" value="{{ request('date_to') }}"
                    mb="0" />
            </div>
            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                <x-basics.button-link href="{{ route('customers.debts.index', $customer) }}" variant="outline">
                    <i class="ph ph-arrow-clockwise mr-2"></i>
                    Reset
                </x-basics.button-link>
            </div>
        </form>
    </div>

    <!-- Debts Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Dettes de {{ $customer->name }}</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($debts->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Vente</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant total</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant payé</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant restant</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date échéance</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date création</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($debts as $debt)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($debts->currentPage() - 1) * $debts->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    @if ($debt->sale)
                                        <x-basics.link href="{{ route('sales.show', $debt->sale) }}" wire:navigate size="md">
                                            {{ $debt->sale->sale_number ?? '—' }}
                                        </x-basics.link>
                                    @else
                                        —
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->total_debt_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->paid_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->remaining_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2">
                                    @if ($debt->status === \App\Models\Debt::STATUS_PAID)
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                            <i class="ph ph-check-circle mr-1"></i>
                                            Payée
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                            <i class="ph ph-clock mr-1"></i>
                                            En attente
                                        </span>
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $debt->due_date?->format('d/m/Y') ?? '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $debt->created_at?->format('d/m/Y') ?? '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-credit-card text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune dette trouvée</p>
                        <p class="text-sm">Ce client n'a pas de dettes enregistrées</p>
                    </div>
                </div>
            @endif
        </div>
        @if ($debts->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $debts->links() }}
            </div>
        @endif
    </div>
</div>
