<div class="container mx-auto" x-data="{ showCreateCustomerModal: false }">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Clients' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateCustomerModal = true">
                <i class="ph ph-plus mr-2"></i>
                Nouveau client
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('customers.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher..." placeholder="Nom, téléphone ou email..."
                    value="{{ request('search') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statusOptions" optionLabel="label"
                    optionValue="value" value="{{ request('status') }}" mb="0" />
            </div>
            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('status'))
                    <x-basics.button-link href="{{ route('customers.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Customers Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des clients</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($customers->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Nom</th>
                            <th class="p-3 text-left font-medium text-gray-700">Téléphone</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                            <th class="p-3 text-left font-medium text-gray-700">Dernière vente</th>
                            <th class="p-3 text-left font-medium text-gray-700">Création</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach ($customers as $customer)
                            <tr class="hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($customers->currentPage() - 1) * $customers->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('customers.show', $customer) }}" wire:navigate
                                        size="md">
                                        {{ $customer->name ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $customer->contact?->phone ?? '—' }}
                                </td>
                                <td class="px-3 py-2">
                                    {!! $customer->getStatusBadge() !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $customer->sales->last()?->created_at?->format('d/m/Y') ?? '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $customer->created_at->format('d/m/Y') ?? '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-users text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucun client trouvé</p>
                        <p class="text-sm">Commencez par créer votre premier client</p>
                    </div>
                </div>
            @endif
        </div>
        @if ($customers->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $customers->links() }}
            </div>
        @endif
    </div>

    <!-- Create Customer Modal -->
    <form action="{{ route('customers.store') }}" method="POST">
        @csrf
        <x-basics.modal :show="'showCreateCustomerModal'" title="Ajouter un client" size="lg">
            <div class="space-y-4">
                <x-basics.input name="name" label="Nom complet" placeholder="Nom et prénom" required
                    :error="$errors->first('name')" />

                <x-basics.input name="phone" label="Téléphone" placeholder="Numéro de téléphone" required
                    :error="$errors->first('phone')" />
            </div>

            <x-slot name="footer">
                <x-basics.button type="submit" class="w-full">
                    <i class="ph ph-plus mr-2"></i>
                    Créer le client
                </x-basics.button>
            </x-slot>
        </x-basics.modal>
    </form>
</div>
