<div class="bg-white border border-gray-300 rounded shadow relative">
    <div wire:loading.flex class="absolute inset-0 bg-white/70 backdrop-blur-sm z-10 items-center justify-center rounded">
        <x-basics.spinner size="md" text="Chargement..." />
    </div>

    <div class="p-4 border-b flex items-center justify-between">
        <div>
            <h4 class="font-semibold text-gray-800">Dernières Prescriptions</h4>
            <p class="text-xs text-gray-500 mt-0.5">{{ count($prescriptions) }} prescription(s) récente(s)</p>
        </div>
        <button wire:click="refreshPrescriptions" wire:loading.attr="disabled" 
            class="text-gray-600 hover:text-gray-800 transition-colors">
            <i class="ph ph-arrows-clockwise text-lg"></i>
        </button>
    </div>

    <div class="overflow-x-auto">
        @if (count($prescriptions) > 0)
            <table class="min-w-full text-sm">
                <thead class="bg-gray-50">
                    <tr class="text-left text-gray-700 font-medium">
                        <th class="p-3">Référence</th>
                        <th class="p-3">Client</th>
                        <th class="p-3">Produits</th>
                        <th class="p-3">Statut</th>
                        <th class="p-3">Date</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($prescriptions as $prescription)
                        <tr class="border-t hover:bg-gray-50 transition-colors">
                            <td class="px-3 py-2">
                                <a href="{{ route('prescriptions.show', $prescription['reference'] ?? '#') }}" 
                                   class="text-blue-600 hover:text-blue-800 font-semibold">
                                    {{ $prescription['reference'] ?? '—' }}
                                </a>
                            </td>
                            <td class="px-3 py-2 text-gray-700">
                                {{ $prescription['customer_name'] ?? 'Client inconnu' }}
                            </td>
                            <td class="px-3 py-2 text-gray-600">
                                {{ $prescription['products_count'] ?? 0 }}
                            </td>
                            <td class="px-3 py-2">
                                @php
                                    $status = $prescription['status'] ?? null;
                                @endphp
                                {!! \App\Models\Prescription::getStatusBadge($status) !!}
                            </td>
                            <td class="px-3 py-2 text-gray-600">
                                @php
                                    $createdAt = $prescription['created_at'] ?? null;
                                    if (is_string($createdAt)) {
                                        $createdAt = \Carbon\Carbon::parse($createdAt);
                                    }
                                @endphp
                                {{ $createdAt ? $createdAt->format('d/m/Y H:i') : '—' }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="text-center py-12">
                <div class="text-gray-500">
                    <i class="ph ph-prescription text-4xl mb-4"></i>
                    <p class="text-lg font-medium">Aucune prescription récente</p>
                    <p class="text-sm">
                        Les dernières prescriptions apparaîtront ici dès qu'elles seront créées.
                    </p>
                </div>
            </div>
        @endif
    </div>

    @if (count($prescriptions) > 0)
        <div class="p-4 border-t bg-gray-50">
            <a href="{{ route('prescriptions.index') }}" 
               class="text-sm text-blue-600 hover:text-blue-800 font-medium flex items-center justify-center gap-2">
                Voir toutes les prescriptions
                <i class="ph ph-arrow-right"></i>
            </a>
        </div>
    @endif
</div>
