<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Dettes' => null,
    ]" />

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('debts.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher..." placeholder="Nom du client..."
                    value="{{ request('search') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statusOptions" optionLabel="label" optionValue="value"
                    value="{{ request('status') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.input name="date_from" label="Date de début" type="date"
                    value="{{ request('date_from') }}" mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.input name="date_to" label="Date de fin" type="date" value="{{ request('date_to') }}"
                    mb="0" />
            </div>
            <div class="flex-1">
                <x-basics.select name="overdue" label="Échéance" placeholder="Tous" 
                    :options="[
                        (object) ['value' => '', 'label' => 'Tous'],
                        (object) ['value' => '1', 'label' => 'En retard'],
                    ]" optionLabel="label" optionValue="value"
                    value="{{ request('overdue') }}" mb="0" />
            </div>
            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('status') || request('date_from') || request('date_to') || request('overdue'))
                    <x-basics.button-link href="{{ route('debts.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Debts Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des Dettes</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($debts->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Référence</th>
                            <th class="p-3 text-left font-medium text-gray-700">Client</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant total</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant payé</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant restant</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date échéance</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date création</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($debts as $debt)
                            <tr class="border-t hover:bg-gray-50 {{ $debt->isOverdue() ? 'bg-red-50' : '' }}">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($debts->currentPage() - 1) * $debts->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('debts.show', $debt) }}" wire:navigate size="md">
                                        {{ $debt->debt_number }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('customers.show', $debt->customer) }}" wire:navigate size="md">
                                        {{ $debt->customer->name ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->total_debt_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->paid_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ number_format($debt->remaining_amount ?? 0, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                </td>
                                <td class="px-3 py-2">
                                    {!! $debt->getStatusBadge() !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    @if ($debt->due_date)
                                        <span class="{{ $debt->isOverdue() ? 'text-red-600 font-medium' : '' }}">
                                            {{ $debt->due_date->format('d/m/Y') }}
                                        </span>
                                        @if ($debt->isOverdue())
                                            <br><span class="text-xs text-red-500">
                                                {{ abs($debt->days_until_due) }} jour{{ abs($debt->days_until_due) > 1 ? 's' : '' }} de retard
                                            </span>
                                        @endif
                                    @else
                                        —
                                    @endif
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $debt->created_at?->format('d/m/Y') ?? '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-credit-card text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune dette trouvée</p>
                        <p class="text-sm">Aucune dette ne correspond aux critères de recherche</p>
                    </div>
                </div>
            @endif
        </div>
        @if ($debts->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $debts->links() }}
            </div>
        @endif
    </div>
</div>