<div class="container mx-auto">
    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Catégories de Dépenses' => route('expense-categories.index'),
        $category->name => route('expense-categories.show', $category),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.expense-categories.dropdown :expenseCategory="$category" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <form wire:submit.prevent="save">
                <x-basics.card title="Modifier la Catégorie" subtitle="Modifiez les informations de la catégorie">
                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000" />
                    </x-slot>

                    <div class="space-y-4">
                        <x-basics.input 
                            wire:model.defer="name" 
                            name="name" 
                            label="Nom de la catégorie"
                            placeholder="Entrez le nom de la catégorie"
                            required 
                            mb="mb-0" />

                        <x-basics.textarea 
                            wire:model.defer="description" 
                            name="description" 
                            label="Description"
                            placeholder="Description de la catégorie (optionnel)"
                            rows="3" 
                            mb="mb-0" />
                    </div>

                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="$loading" leftIcon="floppy-disk">
                            Enregistrer les modifications
                        </x-basics.button>
                    </x-slot>
                </x-basics.card>
            </form>
        </div>
        
        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.expense-categories.sidebar :expenseCategory="$category" />
        </div>
    </div>
</div>
