<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Catégories de Dépenses' => route('expense-categories.index'),
        $category->name => null,
    ]">
        <x-slot name="action">
            <x-dashboard.expense-categories.dropdown :expenseCategory="$category" />
        </x-slot>
    </x-dashboard.breadcrumb>

        <div class="flex gap-6 mt-6">
            <!-- Main Content -->
            <div class="w-full lg:w-8/12 space-y-6">
                <x-basics.card title="Informations de la Catégorie" subtitle="Détails de la catégorie">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Category Name -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-tag text-blue-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Nom de la catégorie</h3>
                                    <p class="text-sm text-gray-600">{{ $category->name }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Expenses Count -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-receipt text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Nombre de dépenses</h3>
                                    <p class="text-sm text-gray-600">{{ $category->expenses_count }} dépenses</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Created Date -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-calendar text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Créée le</h3>
                                    <p class="text-sm text-gray-600">{{ $category->created_at->format('d/m/Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Updated Date -->
                        @if ($category->updated_at != $category->created_at)
                            <div class="bg-gray-50 rounded-lg p-4">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                        <i class="ph ph-clock text-orange-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-gray-900">Modifiée le</h3>
                                        <p class="text-sm text-gray-600">{{ $category->updated_at->format('d/m/Y H:i') }}</p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                    
                    @if ($category->description)
                        <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                            <div class="flex items-start">
                                <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                    <i class="ph ph-note text-yellow-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                    <p class="text-sm text-gray-700">{{ $category->description }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </x-basics.card>

                <!-- Recent Expenses -->
                <x-basics.card title="Dépenses Récentes" subtitle="Dernières dépenses de cette catégorie">
                    @if ($category->expenses->count() > 0)
                        <div class="space-y-4">
                            @foreach ($category->expenses->take(5) as $expense)
                                <div class="flex items-center justify-between p-4 border rounded-lg">
                                    <div class="flex items-center space-x-4">
                                        <div class="w-3 h-3 rounded-full bg-blue-500">
                                        </div>
                                        <div>
                                            <p class="font-medium text-gray-900">{{ $expense->title }}</p>
                                            <p class="text-sm text-gray-500">{{ $expense->created_at->format('d/m/Y') }}</p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="font-semibold text-gray-900">{{ $expense->formatted_amount }}</p>
                                        <span
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $expense->status == 1 ? 'bg-green-100 text-green-800' : ($expense->status == 0 ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') }}">
                                            {{ $expense->status == 1 ? 'Approuvée' : ($expense->status == 0 ? 'En attente' : 'Rejetée') }}
                                        </span>
                                    </div>
                                </div>
                            @endforeach

                            @if ($category->expenses->count() > 5)
                                <div class="text-center pt-4">
                                    <x-basics.button-link
                                        href="{{ route('expenses.index') }}?category_id={{ $category->id }}"
                                        variant="outline" class="w-full">
                                        Voir toutes les dépenses
                                    </x-basics.button-link>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="text-center text-gray-500 py-12">
                            <i class="ph ph-folder-open text-4xl mb-4 text-gray-300"></i>
                            <p class="text-lg font-medium mb-4">Aucune dépense trouvée</p>
                        </div>
                    @endif
                </x-basics.card>

            </div>

            <!-- Sidebar -->
            <div class="w-full lg:w-4/12 space-y-6">
                <x-dashboard.expense-categories.sidebar :expenseCategory="$category" />
            </div>
        </div>
    </div>
</div>
