<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dépenses' => route('expenses.index'),
        $expense->title => route('expenses.show', $expense),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.expenses.dropdown :expense="$expense" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <form wire:submit.prevent="save">
        <div class="flex flex-col lg:flex-row gap-6 mt-6">
            <!-- Main Content -->
            <div class="w-full lg:w-8/12 space-y-6">
                <x-basics.card title="Modifier la Dépense" subtitle="Modifiez les informations de la dépense">
                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000" />
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000" />
                    </x-slot>


                    <div class="space-y-4">
                        <x-basics.input wire:model.defer="title" name="title" label="Titre"
                            placeholder="Entrez le titre de la dépense" mb="mb-0" required />

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <x-basics.select wire:model.defer="expense_category_id" name="expense_category_id"
                                label="Catégorie" placeholder="Sélectionner une catégorie" :options="$categories"
                                optionValue="id" optionLabel="name" mb="mb-0" required />

                            <x-basics.input wire:model.defer="amount" name="amount" label="Montant (CDF)"
                                type="number" placeholder="0.00" step="0.01" min="0.01" mb="mb-0"
                                required />
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <x-basics.input wire:model.defer="expense_date" name="expense_date" label="Date de Dépense"
                                type="date" mb="mb-0" required />

                        </div>

                        <x-basics.textarea wire:model.defer="description" name="description" label="Description"
                            placeholder="Description de la dépense (optionnel)" rows="3" mb="mb-0" />
                    </div>

                    <x-slot name="footer">
                        <x-basics.button :disabled="$loading" type="submit" class="w-full" wireTarget="save">
                            <span wire:loading.remove>Enregistrer les modifications</span>
                            <span wire:loading wire:target="save">Enregistrement en cours...</span>
                        </x-basics.button>
                    </x-slot>

                </x-basics.card>
            </div>

            <!-- Sidebar -->
            <div class="w-full lg:w-4/12 space-y-6">
                <x-dashboard.expenses.sidebar :expense="$expense" />
            </div>


        </div>
    </form>
</div>
