<div class="container mx-auto" x-data="{ showCreateExpenseModal: false }">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Dépenses' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateExpenseModal = true">
                <i class="ph ph-plus mr-2"></i>
                Nouvelle dépense
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('expenses.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher par titre..." placeholder="Rechercher par titre..."
                    value="{{ request('search') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="category_id" label="Catégorie" placeholder="Toutes" :options="$categories" optionLabel="label" optionValue="value"
                    value="{{ request('category_id') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statuses" optionLabel="label" optionValue="value"
                    value="{{ request('status') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.input name="start_date" label="Date début" type="date" value="{{ request('start_date') }}"
                    mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.input name="end_date" label="Date fin" type="date" value="{{ request('end_date') }}"
                    mb="0" />
            </div>

            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('category_id') || request('status') || request('start_date') || request('end_date'))
                    <x-basics.button-link href="{{ route('expenses.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>
        </form>
    </div>

    <!-- Expenses Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des dépenses</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($expenses->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Dépense</th>
                            <th class="p-3 text-left font-medium text-gray-700">Catégorie</th>
                            <th class="p-3 text-left font-medium text-gray-700">Montant</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($expenses as $expense)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration + ($expenses->currentPage() - 1) * $expenses->perPage() }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('expenses.show', $expense) }}" wire:navigate size="md">
                                        {{ $expense->title ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    <x-basics.link href="{{ route('expense-categories.show', $expense->category) }}" wire:navigate size="md">
                                        {{ $expense->category?->name ?? '—' }}
                                    </x-basics.link>
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $expense->formatted_amount ?? '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $expense->formatted_date ?? '—' }}
                                </td>
                                <td class="px-3 py-2">
                                    {!! $expense->status_badge !!}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-receipt text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucune dépense trouvée</p>
                        <p class="text-sm">Commencez par créer votre première dépense</p>
                    </div>
                </div>
            @endif
        </div>

        @if ($expenses->hasPages())
            <div class="px-4 py-4 border-t">
                {{ $expenses->links() }}
            </div>
        @endif
    </div>

    <!-- Create Expense Modal -->
    <form action="{{ route('expenses.store') }}" method="POST">
        @csrf
        <x-basics.modal :show="'showCreateExpenseModal'" title="Créer une nouvelle dépense" size="lg">
            <div>
                <x-basics.select name="expense_category_id" label="Catégorie" placeholder="Sélectionner une catégorie" class="mb-4"
                :options="$categories" optionValue="value" optionLabel="label" required
                :error="$errors->first('expense_category_id')" />

                <x-basics.input name="title" label="Titre de la dépense" class="mb-4"
                    placeholder="Ex. Achat fournitures, Frais transport..." required :error="$errors->first('title')" />

                <x-basics.input name="amount" label="Montant [{{ \App\Models\Setting::DEFAULT_CURRENCY }}]" placeholder="Montant" required :error="$errors->first('amount')" />
            </div>

            <x-slot name="footer">
                <x-basics.button type="submit" class="w-full">
                    <i class="ph ph-plus mr-2"></i>
                    Créer la dépense
                </x-basics.button>
            </x-slot>
        </x-basics.modal>
    </form>

</div>
