<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Dépenses' => route('expenses.index'),
        $expense->title => null,
    ]">
        <x-slot name="action">
            <x-dashboard.expenses.dropdown :expense="$expense" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations de la Dépense" subtitle="Détails complets de la transaction">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Expense Title -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-receipt text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Titre</h3>
                                <p class="text-sm text-gray-600">{{ $expense->title }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Amount -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-currency-circle-dollar text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Montant</h3>
                                <p class="text-sm font-bold text-indigo-600">{{ $expense->formatted_amount }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Category -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-folder text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Catégorie</h3>
                                <p class="text-sm text-gray-600">{{ $expense->category->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Created By -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Créé par</h3>
                                <p class="text-sm text-gray-600">{{ $expense->user->firstname ." ". $expense->user->lastname ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>

                </div>

                @if ($expense->description)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                <p class="text-sm text-gray-600">{{ $expense->description }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if ($expense->notes)
                    <div class="mt-6 bg-gray-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-gray-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-clipboard-text text-gray-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                <p class="text-sm text-gray-600">{{ $expense->notes }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Status Timeline -->
            <x-basics.card title="Historique des Statuts" subtitle="Progression de la dépense">
                <div class="space-y-4">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full mr-3"></div>
                        <div>
                            <p class="font-medium text-gray-900">Créée</p>
                            <p class="text-sm text-gray-500">{{ $expense->created_at->format('d/m/Y H:i') }}</p>
                        </div>
                    </div>

                    @if ($expense->isApproved())
                        <div class="flex items-center">
                            <div class="w-3 h-3 bg-green-500 rounded-full mr-3"></div>
                            <div>
                                <p class="font-medium text-gray-900">
                                    Approuvée
                                </p>
                                <p class="text-sm text-gray-500">{{ $expense->updated_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    @endif

                </div>
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.expenses.sidebar :expense="$expense" />
        </div>
    </div>
</div>
