<div class="min-h-screen flex flex-col md:flex-row">

    <!-- Left Column - Form -->
    <div class="w-full md:w-1/3 flex items-center justify-center px-4 py-8 md:px-8 relative">

        <div class="w-full max-w-md px-8">

            <x-basics.section-title title="Code de licence"
                Subtitle="Entrez votre code de licence pour accéder à votre compte." />

            <form wire:submit.prevent="submitLicense" class="space-y-6 mt-6">
                <div class="mb-4">
                    <x-basics.input type="text" name="licence_code" label="Code de licence"
                        placeholder="Code de licence" wire:model.blur="licence_code"
                        :error="$errors->first('licence_code')" />
                </div>

                <x-basics.button :disabled="$loading" type="submit" class="w-full" wireTarget="submitLicense">
                    <span wire:loading.remove wire:target="submitLicense">Valider</span>
                    <span wire:loading wire:target="submitLicense">Validation en cours...</span>
                </x-basics.button>
            </form>

            {{-- LOGOUT --}}
            <form action="{{ route('logout') }}" method="POST">
                @csrf
                <x-basics.link button size="sm" type="submit" class="w-full mt-4">
                    Se déconnecter
                </x-basics.link>
            </form>

        </div>

        <footer class="absolute bottom-0 left-0 right-0">
            <div class="flex justify-center items-center">
                <p class="text-sm text-gray-500">Copyright © 2025 Ango. Tous droits réservés.</p>
            </div>
        </footer>

    </div>

    <!-- Right Column - Background Image (Hidden on mobile) -->
    <div class="hidden md:flex md:w-2/3 items-center justify-center">
        <div class="w-full h-full bg-cover bg-center bg-no-repeat bg-black/70 shad"
            style="background-image: url('{{ asset('images/bg-license.png') }}');">
        </div>
    </div>

</div>
