<form wire:submit.prevent="deactivate">
    @if ($error && $error_message)
        <div class="mb-4 p-4 bg-red-50 border border-red-200 rounded-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="ph ph-warning text-red-400"></i>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-800">{{ $error_message }}</p>
                </div>
            </div>
        </div>
    @endif

    <div class="text-gray-600">
        Êtes-vous sûr de vouloir désactiver cet établissement ?
        <p class="mb-0">
            Votre établissement sera désactivé et inaccessible par tous les utilisateurs. 
            Vous ne serez plus capable de recevoir des prescriptions de médicaments à traiter.
        </p>
    </div>

    <div class="mt-6 border-t border-gray-200 pt-6">

        <x-basics.button variant="danger" :disabled="$deactivating" type="submit" class="w-full" wireTarget="deactivate">
            <span wire:loading.remove>Désactiver l'établissement</span>
            <span wire:loading wire:target="deactivate">Désactivation en cours...</span>
        </x-basics.button>

    </div>

</form>
