<div>
    <div class="container mx-auto">

        {{-- Breadcrumb --}}
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            $merchantInfo['name'] ?? 'Nom de l\'établissement' => null,
        ]">
            <x-slot name="action">
                <x-dashboard.merchants.dropdown />
            </x-slot>
        </x-dashboard.breadcrumb>

        <div class="flex gap-6 mt-6">
            <div class="w-full space-y-6">

                {{-- Map --}}
                @if ($merchantInfo['latitude'] && $merchantInfo['longitude'])
                    <x-basics.card title="Carte de l'établissement" subtitle="Voir l'établissement sur la carte">
                        <div class="w-full h-96" wire:ignore.self>
                            <div id="merchant-map" style="width: 100%; height: 100%;"
                                class="bg-gray-100 flex items-center justify-center">
                                <div class="text-gray-500">
                                    <div
                                        class="animate-spin rounded-full h-8 w-8 border-b-2 border-indigo-600 mx-auto mb-2">
                                    </div>
                                    <p class="text-sm">Chargement de la carte...</p>
                                </div>
                            </div>
                        </div>
                    </x-basics.card>
                @endif

                {{-- Merchant Information --}}
                <x-basics.card title="Informations de l'établissement" subtitle="Détails complets de l'établissement">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                        {{-- Merchant Name --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-buildings text-blue-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Nom de l'établissement</h3>
                                    <p class="text-sm text-gray-600">{{ $merchantInfo['name'] ?? '-' }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- Status --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-info text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Statut</h3>
                                    <p class="text-sm text-gray-600">
                                        {{ \App\Models\Merchant::getStatusName($merchantInfo['status']) }}
                                    </p>
                                </div>
                            </div>
                        </div>

                        {{-- Phone --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-phone text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Téléphone</h3>
                                    <p class="text-sm text-gray-600">{{ $merchantInfo['phone'] ?? 'Non défini' }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- Email --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-envelope text-orange-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Email</h3>
                                    <p class="text-sm text-gray-600">{{ $merchantInfo['email'] ?? 'Non défini' }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- Business Type --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-tag text-cyan-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Type d'entreprise</h3>
                                    <p class="text-sm text-gray-600">
                                        {{ \App\Models\Merchant::getTypeName($merchantInfo['type']) }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- CNOP --}}
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-emerald-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-identification-card text-emerald-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">CNOP</h3>
                                    <p class="text-sm text-gray-600">{{ $merchantInfo['cnop'] ?? 'Non défini' }}</p>
                                </div>
                            </div>
                        </div>

                        {{-- Address --}}
                        @if ($merchantInfo['address'])
                            <div class="bg-gray-50 rounded-lg p-4 md:col-span-2">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                        <i class="ph ph-map-pin text-red-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-gray-900">Adresse</h3>
                                        <p class="text-sm text-gray-600">
                                            {{ $merchantInfo['address'] }}
                                            @php
                                                $city = $merchantInfo['city'] ?? null;
                                                $province = $merchantInfo['province'] ?? null;
                                            @endphp
                                            @if ($city || $province)
                                                @if ($city && $province)
                                                    , {{ $city }}, {{ $province }}
                                                @elseif ($city)
                                                    , {{ $city }}
                                                @elseif ($province)
                                                    , {{ $province }}
                                                @endif
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </x-basics.card>

            </div>
        </div>
    </div>

    {{-- SCRIPTS --}}
    @push('scripts')
        {{-- Leaflet CSS/JS from local files for offline compatibility --}}
        <link rel="stylesheet" href="{{ asset('plugins/leaflet/leaflet.css') }}" />
        <script src="{{ asset('plugins/leaflet/leaflet.js') }}"></script>

        <script>
            document.addEventListener('DOMContentLoaded', initMerchantShowMap);
            document.addEventListener('livewire:navigate', () => setTimeout(initMerchantShowMap, 200));
            document.addEventListener('livewire:navigated', () => setTimeout(initMerchantShowMap, 200));

            function initMerchantShowMap() {
                const mapEl = document.getElementById('merchant-map');
                if (!mapEl) return;

                // Check if Leaflet is loaded
                if (typeof L === 'undefined') {
                    console.error('Leaflet library not loaded. Attempting to load from CDN...');
                    loadLeafletFromCDN();
                    return;
                }

                // Remove old instance
                if (window.merchantShowMap?.map) {
                    window.merchantShowMap.map.remove();
                }

                const lat = {{ json_encode($merchantInfo['latitude'] ?? -4.4419) }};
                const lng = {{ json_encode($merchantInfo['longitude'] ?? 15.2663) }};
                const name = @json($merchantInfo['name'] ?? 'Établissement');
                const address = @json($merchantInfo['address'] ?? '');

                window.merchantShowMap = {};
                const map = L.map(mapEl).setView([lat, lng], 15);
                window.merchantShowMap.map = map;

                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '© OpenStreetMap contributors'
                }).addTo(map);

                const customIcon = L.divIcon({
                    className: 'custom-marker-icon',
                    html: `<div style="width: 32px; height: 32px; background-color: #4f46e5; border-radius: 50%; border: 2px solid white; display:flex;align-items:center;justify-content:center;">
                        <i class='ph ph-map-pin' style='color:white;font-size:16px;'></i></div>`,
                    iconSize: [32, 32],
                    iconAnchor: [16, 16]
                });

                const marker = L.marker([lat, lng], { icon: customIcon }).addTo(map);
                marker.bindPopup(`<div><strong>${name}</strong><br>${address}</div>`);

                setTimeout(() => map.invalidateSize(), 300);
            }

            function loadLeafletFromCDN() {
                console.log('Loading Leaflet from CDN as fallback...');
                
                // Load CSS
                const cssLink = document.createElement('link');
                cssLink.rel = 'stylesheet';
                cssLink.href = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css';
                document.head.appendChild(cssLink);
                
                // Load JS
                const script = document.createElement('script');
                script.src = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.js';
                script.onload = function() {
                    console.log('Leaflet loaded from CDN successfully');
                    setTimeout(initMerchantShowMap, 100);
                };
                script.onerror = function() {
                    console.error('Failed to load Leaflet from CDN');
                    const mapElement = document.getElementById('merchant-map');
                    if (mapElement) {
                        mapElement.innerHTML = '<div class="flex items-center justify-center h-full bg-gray-100 text-gray-500"><p>Erreur: Impossible de charger la carte. Vérifiez votre connexion internet.</p></div>';
                    }
                };
                document.head.appendChild(script);
            }
        </script>

        <style>
            .leaflet-container {
                z-index: 0;
            }

            .custom-marker-icon {
                background: transparent !important;
                border: none !important;
            }

            .custom-marker-icon div {
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
            }
        </style>
    @endpush
</div>
