<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Méthodes de paiement' => route('payment-methods.index'),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.payment-methods.dropdown :paymentMethod="$paymentMethod" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex flex-col lg:flex-row gap-6 mt-6">
        <div class="w-full lg:w-8/12 space-y-6">
            <form wire:submit.prevent="save" class="space-y-4">
                <x-basics.card title="Modifier la méthode de paiement" subtitle="Mettre à jour les informations">

                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :message="$successMessage" :timeout="3000" />
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000" />
                    </x-slot>

                    <div class="grid grid-cols-1 gap-4">
                        <div class="mb-4">
                            <x-basics.input name="name" label="Nom" wire:model.live.debounce.1000ms="name" required :error="$errors->first('name')" />
                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-4">
                        <div class="mb-4">
                            <x-basics.textarea name="description" label="Description" wire:model.live.debounce.1000ms="description" :error="$errors->first('description')" rows="4" />
                        </div>
                    </div>

                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="!$can_save || $loading" leftIcon="floppy-disk" wire:target="save">
                            @if($loading)
                                Enregistrement...
                            @else
                                Enregistrer les modifications
                            @endif
                        </x-basics.button>
                    </x-slot>
                </x-basics.card>
            </form>
        </div>

        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.payment-methods.sidebar :paymentMethod="$paymentMethod" />
        </div>
    </div>
</div>


