<div>
    <main class="container mx-auto" x-data="{ showCreateModal: false }">

        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Méthodes de paiement' => null,
        ]">
            <x-slot name="action">
                <div class="flex items-center gap-2">
                    <x-basics.button @click="showCreateModal = true">
                        <i class="ph ph-plus mr-2"></i>
                        Nouvelle méthode
                    </x-basics.button>
                </div>
            </x-slot>
        </x-dashboard.breadcrumb>

        <div class="mt-6">
            <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm mb-8">
                <div class="p-4 border-b">
                    <h4 class="font-semibold text-gray-800">Liste des méthodes de paiement</h4>
                    <p class="text-sm text-gray-500">Voir la liste de toutes les méthodes</p>
                </div>
                <div class="overflow-x-auto">
                    @if ($paymentMethods->count() > 0)
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Nom</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Description</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($paymentMethods as $pm)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2 font-medium">
                                            {{ ($paymentMethods->currentPage() - 1) * $paymentMethods->perPage() + $loop->iteration }}.
                                        </td>
                                        <td class="px-3 py-2">
                                            <x-basics.link size="normal" href="{{ route('payment-methods.show', $pm) }}">
                                                {{ $pm->name }}
                                            </x-basics.link>
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">{{ Str::limit($pm->description ?? '—', 75) }}</td>
                                        <td class="px-3 py-2">{!! $pm->status_badge !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if ($paymentMethods->hasPages())
                            <div class="p-4 border-t bg-gray-50">
                                {{ $paymentMethods->onEachSide(1)->links() }}
                            </div>
                        @endif
                    @else
                        <div class="text-center py-12">
                            <div class="text-gray-500">
                                <i class="ph ph-credit-card text-4xl mb-4"></i>
                                <p class="text-lg font-medium">Aucune méthode de paiement trouvée</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <form method="POST" action="{{ route('payment-methods.store') }}">
            @csrf
            <x-basics.modal show="showCreateModal" title="Nouvelle méthode de paiement" description="Créer une nouvelle méthode de paiement">
                <div class="mb-4">
                    <x-basics.input name="name" label="Nom" value="{{ old('name') }}" required />
                </div>
                @slot('footer')
                    <x-basics.button type="submit" variant="primary" class="w-full">
                        Ajouter la méthode de paiement
                    </x-basics.button>
                @endslot
            </x-basics.modal>
        </form>

    </main>
</div>


