<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Méthodes de paiement' => route('payment-methods.index'),
        $paymentMethod->name => null,
    ]">
        <x-slot name="action">
            <x-dashboard.payment-methods.dropdown :paymentMethod="$paymentMethod" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations" subtitle="Détails de la méthode de paiement">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Payment Method Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-credit-card text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom de la méthode</h3>
                                <p class="text-sm text-gray-600">{{ $paymentMethod->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Created Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Créée le</h3>
                                <p class="text-sm text-gray-600">{{ $paymentMethod->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($paymentMethod->description)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                <p class="text-sm text-gray-600">{{ $paymentMethod->description }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.payment-methods.sidebar :paymentMethod="$paymentMethod" />
        </div>
    </div>
</div>
