<div class="container mx-auto">
    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Produits' => route('products.index'),
        $product->name => route('products.show', $product),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            @if (auth()->user()->isAdmin() || auth()->user()->isOwner())
            <x-dashboard.products.dropdown :product="$product" />
            @endif
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Edit Forms -->
            <div class="flex flex-col gap-6">
                <!-- General Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveGeneral">
                        <x-basics.card title="Informations générales">
                            <x-slot name="action">
                                <x-basics.flash :model="'successGeneral'" :timeout="3000" />
                            </x-slot>

                            <div class="space-y-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <x-basics.input label="Nom du produit" required wire:model.defer="name"
                                        name="name" placeholder="Ex. Paracetamol" mb="mb-0" />

                                    <x-basics.input label="Nom générique" wire:model.defer="generic_name"
                                        name="generic_name" placeholder="Ex. Acetaminophen" mb="mb-0" />
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <x-basics.input label="SKU (Code produit)" wire:model.defer="sku" name="sku"
                                        placeholder="Ex. PAR-20250113-001" mb="mb-0" :disabled="true"
                                        hint="Identifiant unique pour le suivi des stocks et la gestion">
                                    </x-basics.input>

                                    <x-basics.input label="Marque" wire:model.defer="brand" name="brand"
                                        placeholder="Ex. Panadol" mb="mb-0" />
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <x-basics.select name="category_id" wire:model.defer="category_id" label="Catégorie"
                                        :options="$categories" optionValue="id" optionLabel="name"
                                        placeholder="Sélectionner une catégorie"
                                        error="{{ $errors->first('category_id') }}" :required="false" :disabled="false"
                                        class="mb-4" />
                                </div>
                            </div>

                            <x-slot name="footer">
                                <x-basics.button type="submit" class="w-full" :disabled="$loading" leftIcon="floppy-disk">
                                    Enregistrer
                                </x-basics.button>
                            </x-slot>
                        </x-basics.card>
                    </form>
                </div>

                <!-- Unit Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveUnits">
                        <x-basics.card title="Stock et unités">
                            <x-slot name="action">
                                <x-basics.flash :model="'successUnits'" :timeout="3000" />
                            </x-slot>

                            <div>
                                <div class="grid grid-cols-2 gap-4">
                                    <x-basics.select name="purchase_unit_id" wire:model.live="purchase_unit_id"
                                        label="Unité d'achat" :options="$units" optionValue="id" optionLabel="name"
                                        placeholder="Ex: Boîte, Bouteille"
                                        error="{{ $errors->first('purchase_unit_id') }}" :required="true"
                                        :disabled="false" class="mb-4" />

                                    <x-basics.select name="sale_unit_id" wire:model.live="sale_unit_id"
                                        label="Unité de vente" :options="$units" optionValue="id" optionLabel="name"
                                        placeholder="Ex: Capsule, Comprimé" error="{{ $errors->first('sale_unit_id') }}"
                                        :required="true" :disabled="false" class="mb-4" />
                                </div>
                                <div class="grid grid-cols-2 gap-4">

                                    <x-basics.input wire:model.defer="conversion_factor" name="conversion_factor"
                                        label="Facteur de conversion" type="number" step="1" min="1"
                                        placeholder="Ex: 24 (1 boîte = 24 capsules)" :required="true"
                                        :disabled="false" class="mb-4" />

                                    <x-basics.input name="reorder_level"
                                        label="Seuil de réapprovisionnement (en {{ strtolower($product->saleUnit?->name ?? 'unité de vente') }})"
                                        type="number" min="0" wire:model.defer="reorder_level" placeholder="0"
                                        mb="mb-0" />
                                </div>
                            </div>

                            <x-slot name="footer">
                                <x-basics.button type="submit" class="w-full" :disabled="$loading"
                                    leftIcon="floppy-disk">
                                    Enregistrer
                                </x-basics.button>
                            </x-slot>
                        </x-basics.card>
                    </form>
                </div>

                <!-- Stock Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveStock">
                        <x-basics.card title="Prix de vente et d'achat">
                            <x-slot name="action">
                                <x-basics.flash :model="'successStock'" :timeout="3000" />
                            </x-slot>

                            @if ($product->purchaseUnit && $product->saleUnit)
                                <div class="grid grid-cols-2 gap-4">
                                    <x-basics.input name="purchase_price"
                                        label="P.A. (CDF) par {{ strtolower($product->purchaseUnit?->name ?? 'unité') }}"
                                        type="number" step="0.01" min="0" wire:model.defer="purchase_price"
                                        placeholder="0.00" mb="mb-0" required />

                                    <x-basics.input name="selling_price"
                                        label="P.V. (CDF) par {{ strtolower($product->saleUnit?->name ?? 'unité') }}"
                                        type="number" step="0.01" min="0"
                                        wire:model.defer="selling_price" placeholder="0.00" mb="mb-0"
                                        required />
                                </div>
                            @else
                                <div class="px-6 py-12 text-center">
                                    <i class="ph ph-list-magnifying-glass mx-auto text-6xl text-gray-400"></i>
                                    <h3 class="mt-2 text-sm font-medium text-gray-900">Aucune unité de vente ou d'achat
                                        trouvée</h3>
                                    <p class="mt-1 text-sm text-gray-500">
                                        Il n'y a pas encore d'unité de vente ou d'achat dans le système.
                                    </p>
                                </div>
                            @endif

                            <x-slot name="footer">
                                <x-basics.button type="submit" class="w-full" :disabled="$loading"
                                    leftIcon="floppy-disk">
                                    Enregistrer
                                </x-basics.button>
                            </x-slot>
                        </x-basics.card>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.products.sidebar :product="$product" />
        </div>
    </div>
</div>
