<div class="container mx-auto" x-data="{ showCreatePharmacyModal: false }">

    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Produits' => null,
    ]">
        <x-slot name="action">
            @if (auth()->user()->isAdmin() || auth()->user()->isOwner())
            <x-basics.button @click="showCreatePharmacyModal = true" variant="primary">
                <i class="ph ph-plus mr-2"></i>
                Ajouter un produit
            </x-basics.button>
            @endif
        </x-slot>
    </x-dashboard.breadcrumb>


    <!-- Filters Section -->
    <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
        <form action="{{ route('products.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
            <div class="flex-1">
                <x-basics.input name="search" label="Rechercher par nom..." placeholder="Rechercher par nom..."
                    value="{{ request('search') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="category_id" label="Catégorie" placeholder="Tous" :options="$categories" optionLabel="label" optionValue="value"
                    value="{{ request('category_id') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="stock_status" label="Stock" placeholder="Tous" :options="\App\Models\Product::STOCK_STATUSES" optionLabel="name" optionValue="id"
                    value="{{ request('stock_status') }}" mb="0" />
            </div>

            <div class="flex-1">
                <x-basics.select name="status" label="Statut" placeholder="Tous" :options="\App\Models\Product::STATUS_LABELS" optionLabel="name" optionValue="id"
                    value="{{ request('status') }}" mb="0" />
            </div>


            <div class="flex gap-2">
                <x-basics.button type="submit">
                    <i class="ph ph-magnifying-glass mr-2"></i>
                    Filtrer
                </x-basics.button>
                @if (request('search') || request('category_id') || request('stock_status') || request('status'))
                    <x-basics.button-link href="{{ route('products.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                @endif
            </div>


        </form>
    </div>

    <!-- Products Table -->
    <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
        <div class="p-4 border-b">
            <h4 class="font-semibold text-gray-800">Liste des produits</h4>
        </div>
        <div class="overflow-x-auto">
            @if ($products->count() > 0)
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                            <th class="p-3 text-left font-medium text-gray-700">Catégorie</th>
                            <th class="p-3 text-left font-medium text-gray-700">Prix de vente</th>
                            <th class="p-3 text-left font-medium text-gray-700">Stock</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $product)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2">
                                    {{ $loop->iteration }}.
                                </td>
                                <td class="px-3 py-2">
                                    <x-basics.link href="{{ route('products.show', $product) }}" wire:navigate size="md">
                                        {{ $product->name ?? '—' }}
                                    </x-basics.link>
                                </td>

                                <td class="px-3 py-2 text-gray-600">
                                    {{ $product->category?->name ?? '—' }}
                                </td>

                                <td class="px-3 py-2 text-gray-600">
                                    {{ $product->selling_price ? number_format($product->selling_price, 2) . ' ' . \App\Models\Setting::DEFAULT_CURRENCY : '—' }}
                                </td>

                                <td class="px-3 py-2 text-gray-600">
                                    {!! $product->getStockStatusBadge() !!}
                                </td>                             

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="text-center py-12">
                    <div class="text-gray-500">
                        <i class="ph ph-package text-4xl mb-4"></i>
                        <p class="text-lg font-medium">Aucun produit trouvé</p>
                        <p class="text-sm">Commencez par créer votre premier produit</p>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Pagination -->
    @if ($products->hasPages())
        <div class="mt-6">
            {{ $products->links() }}
        </div>
    @endif

    {{-- MODALS --}}
    <form action="{{ route('products.store') }}" method="POST">
        @csrf
        <x-basics.modal show="showCreatePharmacyModal" title="Créer votre produit"
            description="Configurez votre produit" size="lg">

            <x-basics.input name="name" label="Nom" placeholder="Ex. Paracetamol" :error="$errors->first('name')" class="mb-4"
                required />

            <x-basics.select name="category_id" label="Catégorie" placeholder="Choisir une catégorie" :options="$categories" optionLabel="label" optionValue="value"
                value="{{ request('category_id') }}" :error="$errors->first('category_id')" required />

            @slot('footer')
                <x-basics.button type="submit" class="w-full">
                    Ajouter le produit
                </x-basics.button>
            @endslot
        </x-basics.modal>
    </form>

</div>
