<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Bons de commande' => route('purchase-orders.index'),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.purchase-orders.dropdown :purchaseOrder="$purchaseOrder" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- General Information -->
            <form wire:submit.prevent="saveGeneral">
                <x-basics.card title="Informations générales" subtitle="Informations de base du bon de commande">
                    <x-slot name="action">
                        <x-basics.flash :model="'successGeneral'" :timeout="3000" />
                    </x-slot>

                    <div class="space-y-4">
                        @if ($errors->any())
                            <x-basics.alert type="danger" :message="$errors->first()" />
                        @endif

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <x-basics.input label="Référence" wire:model="reference" name="reference" placeholder="Ex. PO-20250120-001"
                                mb="mb-0" :disabled="true" />

                            <x-basics.select name="supplier_id" wire:model.defer="supplier_id" label="Fournisseur" :options="$suppliers"
                                optionValue="id" optionLabel="name" placeholder="Sélectionner un fournisseur" required
                                mb="mb-0" :disabled="$purchaseOrder->status !== App\Models\PurchaseOrder::STATUS_DRAFT" />
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <x-basics.input label="Date de commande" type="date" wire:model.defer="order_date" name="order_date"
                                mb="mb-0" :disabled="$purchaseOrder->status !== App\Models\PurchaseOrder::STATUS_DRAFT" />

                            <x-basics.input label="Date de livraison prévue" type="date"
                                wire:model.defer="expected_delivery_date" name="expected_delivery_date" mb="mb-0"
                                :disabled="$purchaseOrder->status !== App\Models\PurchaseOrder::STATUS_DRAFT" />
                        </div>

                        <x-basics.textarea label="Notes" wire:model.defer="notes" name="notes" rows="2"
                            placeholder="Notes additionnelles sur la commande" mb="mb-0" :disabled="$purchaseOrder->status !== App\Models\PurchaseOrder::STATUS_DRAFT" />
                    </div>

                    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                        <x-slot name="footer">
                            <x-basics.button type="submit" class="w-full" :disabled="$loading" leftIcon="floppy-disk">
                                Enregistrer les modifications
                            </x-basics.button>
                        </x-slot>
                    @endif
                </x-basics.card>
            </form>

            <!-- Order Items -->
            <x-basics.card title="Articles commandés" subtitle="Gérez les articles de cette commande">
                <x-slot name="action">
                    <x-basics.flash :model="'successItems'" :timeout="3000"/>
                </x-slot>

                @if ($purchaseOrder->items->count() > 0)
                    <div class="overflow-x-auto mb-6">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                                <tr>
                                    <th class="px-3 py-2">Produit</th>
                                    <th class="px-3 py-2">Quantité</th>
                                    <th class="px-3 py-2">Unité</th>
                                    <th class="px-3 py-2">Prix unitaire</th>
                                    <th class="px-3 py-2">Prix total</th>
                                    @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                                        <th class="px-3 py-2"></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100 text-sm text-gray-700">
                                @foreach ($purchaseOrder->items as $item)
                                    <tr>
                                        <td class="px-3 py-2 font-medium">
                                            {{ $item->product->name ?? 'Produit supprimé' }}
                                        </td>
                                        <td class="px-3 py-2">{{ $item->quantity }}</td>
                                        <td class="px-3 py-2">{{ $item->unit ?? 'pièce' }}</td>
                                        <td class="px-3 py-2">{{ number_format($item->unit_price, 2) }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                                        <td class="px-3 py-2 font-medium">{{ number_format($item->total_price, 2) }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                                        @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                                        <td class="px-3 py-2 text-right">
                                            <x-basics.button variant="outline-red" wire:click="deleteItem({{ $item->id }})"
                                                size="sm">
                                                <i class="ph ph-bold ph-trash"></i>
                                            </x-basics.button>
                                        </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mb-6 p-4 bg-gray-50 rounded-lg">
                        <div class="flex justify-between items-center">
                            <span class="text-lg font-medium">Total de la commande:</span>
                            <span
                                class="text-2xl font-bold text-blue-600">{{ number_format($purchaseOrder->getTotalAmount(), 2) }}
                                {{ \App\Models\Setting::DEFAULT_CURRENCY }}</span>
                        </div>
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <i class="ph ph-package text-4xl mb-2"></i>
                        <p>Aucun article ajouté à cette commande.</p>
                        <p class="text-sm">Utilisez le formulaire ci-dessous pour commencer.</p>
                    </div>
                @endif

                @if ($purchaseOrder->status === App\Models\PurchaseOrder::STATUS_DRAFT)
                    <!-- Add Item Form -->
                    <div class="border-t border-gray-200 pt-6">

                        <x-basics.section-title title="Ajouter un article" subtitle="Le produit que vous ajouterez sera ajouté à la commande" titleSize="lg" titleWeight="bold" subtitleSize="sm" subtitleWeight="normal" class="mb-6" />

                        
                        <form wire:submit.prevent="addItem">
                            <div class="flex gap-4 items-center justify-center">

                                <x-basics.input-select 
                                    name="product_id"
                                    wire:model.live="product_id" 
                                    label="Produit" 
                                    :options="$products"
                                    optionValue="id" 
                                    optionLabel="name" 
                                    placeholder="Produit" 
                                    orientation="top" 
                                    required 
                                    mb="mb-0" 
                                    class="w-2/5"
                                />

                                <x-basics.input
                                    wire:model.defer="quantity"
                                    name="quantity"
                                    label="Quantité"
                                    type="number"
                                    step="0.01"
                                    min="1"
                                    placeholder="1"
                                    mb="mb-0"
                                    required
                                    class="w-1/5"
                                />

                                <x-basics.input
                                    wire:model.defer="unit"
                                    name="unit"
                                    label="Unité"
                                    placeholder="Ex: Pièce, Boîte"
                                    mb="mb-0"
                                    required
                                    class="w-1/5"
                                />

                                <x-basics.input
                                    wire:model.defer="unit_price"
                                    name="unit_price"
                                    label="Prix unitaire"
                                    type="number"
                                    step="0.01"
                                    min="0"
                                    placeholder="0.00"
                                    mb="mb-0"
                                    required
                                    class="w-1/5"
                                />
                            </div>

                            <div class="mt-4 flex">
                                <x-basics.button class="w-full" type="submit" :disabled="$loading" leftIcon="plus">
                                    <span x-show="!$wire.loading">Ajouter l'article</span>
                                    <span x-show="$wire.loading" class="flex items-center justify-center gap-2">
                                        <x-basics.spinner size="sm" variant="primary" />
                                        Ajout...
                                    </span>
                                </x-basics.button>
                            </div>
                        </form>


                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.purchase-orders.sidebar :purchaseOrder="$purchaseOrder" />
        </div>
    </div>
</div>