<div class="container mx-auto" x-data="{ showCreatePurchaseOrderModal: false }">

    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Bons de commande' => null,
    ]">

        <x-slot name="action">
            <x-basics.button @click="showCreatePurchaseOrderModal = true">
                <i class="ph ph-plus mr-2"></i>
                Nouveau bon de commande
            </x-basics.button>
        </x-slot>

    </x-dashboard.breadcrumb>


    <div class="w-full min-h-screen mt-6">

        <!-- Filters Section -->
        <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
            <form action="{{ route('purchase-orders.index') }}" method="GET"
                class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <x-basics.input name="search" label="Rechercher..." placeholder="Référence, fournisseur..."
                        value="{{ request('search') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="supplier_id" label="Fournisseur" placeholder="Tous" :options="$suppliers" optionLabel="name" optionValue="id" value="{{ request('supplier_id') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="status" label="Statut" placeholder="Tous" :options="\App\Models\PurchaseOrder::PURCHASE_ORDER_STATUSES" optionLabel="name" optionValue="id" value="{{ request('status') }}" mb="0" />
                </div>

                <div class="flex gap-2">
                    <x-basics.button type="submit">
                        <i class="ph ph-magnifying-glass mr-2"></i>
                        Filtrer
                    </x-basics.button>
                    @if (request('search') || request('supplier_id') || request('status'))
                        <x-basics.button-link href="{{ route('purchase-orders.index') }}" variant="outline">
                            <i class="ph ph-arrow-clockwise mr-2"></i>
                            Reset
                        </x-basics.button-link>
                    @endif
                </div>
            </form>
        </div>

        <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
            <div class="p-4 border-b">
                <h4 class="font-semibold text-gray-800">Liste des bons de commande</h4>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                            <th class="p-3 text-left font-medium text-gray-700">Référence</th>
                            <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                            <th class="p-3 text-left font-medium text-gray-700">Fournisseur</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date de commande</th>
                            <th class="p-3 text-left font-medium text-gray-700">Date de création</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($purchaseOrders as $purchaseOrder)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2 font-medium">
                                    {{ $loop->iteration }}.
                                </td>
                                <td class="px-3 py-2">
                                    <a href="{{ route('purchase-orders.show', $purchaseOrder) }}"
                                        class="text-sm font-medium text-blue-600 hover:text-blue-900">{{ $purchaseOrder->reference ?? '—' }}
                                    </a>
                                </td>
                                <td class="px-3 py-2">
                                    {!! $purchaseOrder->getStatusBadge() !!}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $purchaseOrder->supplier?->name ?? '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    {{ $purchaseOrder->order_date ? $purchaseOrder->order_date->format('d-m-Y') : '—' }}
                                </td>
                                <td class="px-3 py-2 text-gray-600">
                                    @if ($purchaseOrder && $purchaseOrder->created_at)
                                        {{ Carbon\Carbon::parse($purchaseOrder->created_at)->format('d-m-Y') }}
                                    @else
                                        —
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center">
                                    <div class="text-gray-500">
                                        <i class="ph ph-package text-4xl mb-2"></i>
                                        <p class="text-lg font-medium">
                                            Aucun bon de commande trouvé
                                        </p>
                                        <p class="text-sm">
                                            Commencez par créer votre premier bon de commande.
                                        </p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination -->
        <div class="mt-6">
            {{ $purchaseOrders->links('vendor.pagination.tailwind') }}
        </div>
    </div>

    {{-- MODALS --}}
    <!-- Create Purchase Order Modal -->
    <form action="{{ route('purchase-orders.store') }}" method="POST">
        @csrf
        <x-basics.modal show="showCreatePurchaseOrderModal" title="Créer un bon de commande"
            description="Configurez votre bon de commande">

            <x-basics.select name="supplier_id" label="Fournisseur" :options="$suppliers"
                placeholder="Sélectionner un fournisseur" required mb="0"  />

            @slot('footer')
                <x-basics.button type="submit" class="w-full">
                    Créer le bon de commande
                </x-basics.button>
            @endslot
        </x-basics.modal>
    </form>


</div>
