<div class="container mx-auto">
    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Bons de commande' => route('purchase-orders.index'),
        'Réception' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.purchase-orders.dropdown :purchaseOrder="$purchaseOrder" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full space-y-6" x-data="{ confirmReceiveModal: false, confirmReceiveModal: false }">

            <!-- Purchase Information -->
            <x-basics.card title="Informations de la commande">
                <div class="space-y-3 text-sm">

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">

                        <div>
                            <span class="text-sm font-thin text-gray-700">Référence:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $purchaseOrder->reference }}
                            </p>
                        </div>



                        <div>
                            <span class="text-sm font-thin text-gray-700">Fournisseur:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $purchaseOrder->supplier->name }}
                            </p>
                        </div>

                        <div>
                            <span class="text-sm font-thin text-gray-700">Nombre d'articles:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $purchaseOrder->items->count() }}
                            </p>
                        </div>

                    </div>


                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">

                        <div>
                            <span class="text-sm font-thin text-gray-700">Date de commande:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ $purchaseOrder->order_date->format('d/m/Y') }}
                            </p>
                        </div>


                        <div>
                            <span class="text-sm font-thin text-gray-700">Statut:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {!! $purchaseOrder->getStatusBadge() !!}
                            </p>
                        </div>



                        <div>
                            <span class="text-sm font-thin text-gray-700">Montant total:</span>
                            <p class="text-lg font-semibold text-gray-900">
                                {{ number_format($purchaseOrder->getTotalAmount(), 2) }}
                                {{ \App\Models\Setting::DEFAULT_CURRENCY }}</p>
                        </div>


                    </div>
                </div>
            </x-basics.card>


            <x-basics.card title="Réception des articles"
                subtitle="Sélectionnez les quantités reçues pour chaque article">

                @if ($success)
                    <div class="bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded mb-6">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <i class="ph ph-check-circle text-green-400"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium">Bon de commande reçu avec succès!</p>
                                <p class="text-xs">Redirection en cours...</p>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="space-y-6">

                    <!-- Additional Information -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <x-basics.input wire:model.defer="receiptDate" name="receipt_date" label="Date de réception"
                                type="date" />
                        </div>

                        <div>
                            <x-basics.input name="receipt_number" label="Numéro de réception" type="text"
                                value="{{ $this->batchNumber }}" disabled
                                placeholder="Numéro de réception (optionnel)" />
                        </div>
                    </div>

                    <!-- Items Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Qté commandée</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Qté reçue</th>
                                    <th class="p-3 text-left font-medium text-gray-700">P.U.
                                        ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Date d'expiration</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($purchaseOrder->items as $index => $item)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2">{{ $index + 1 }}.</td>
                                        <td class="px-3 py-2">
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $item->product->name }}</div>
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">{{ number_format($item->quantity) }}
                                        </td>
                                        <td class="px-3 py-2">
                                            <x-basics.input type="number"
                                                name="receivedQuantities.{{ $item->id }}"
                                                wire:model.defer="receivedQuantities.{{ $item->id }}"
                                                class="max-w-30" min="0" max="{{ $item->quantity }}" />
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            <x-basics.input type="number" name="unitPrices.{{ $item->id }}"
                                                wire:model.defer="unitPrices.{{ $item->id }}" class="max-w-30"
                                                min="0" step="0.01" />
                                        </td>
                                        <td class="px-3 py-2">
                                            <x-basics.input type="date" name="expiryDates.{{ $item->id }}"
                                                wire:model.defer="expiryDates.{{ $item->id }}" class="max-w-40"
                                                placeholder="Optionnel" />
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Additional Information -->
                    <div class="grid grid-cols-1 gap-4">
                        <div>
                            <x-basics.textarea wire:model.defer="notes" name="notes" label="Notes"
                                placeholder="Notes sur la réception..." rows="2" />
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex space-x-3 pt-4">
                        <x-basics.button type="button" variant="success" @click="confirmReceiveModal = true"
                            :disabled="$loading">
                            <i class="ph ph-check-circle mr-2"></i>
                            Confirmer la réception
                        </x-basics.button>
                    </div>
                </div>

                <!-- Receive Modal -->
                <x-basics.modal show="confirmReceiveModal" title="Recevoir le bon de commande"
                    description="Confirmer la réception du bon de commande">
                    <p>Voulez-vous vraiment recevoir ce bon de commande ?</p>
                    <p class="text-sm text-gray-600 mt-2">
                        En confirmant, les actions suivantes seront effectuées immédiatement:
                    </p>
                    <ul class="mt-2 text-sm text-gray-600 list-disc list-inside space-y-1">
                        <li>Création d'une entrée de stock pour chaque article avec une quantité reçue &gt; 0.</li>
                        <li>Augmentation du stock produit selon les quantités reçues.</li>
                        <li>Le bon de commande sera marqué comme « Reçu ».</li>
                    </ul>
                    <p class="text-sm text-red-600 mt-3">
                        Cette opération est finale et ne pourra plus être modifiée depuis cet écran.
                    </p>

                    @slot('footer')
                        <div class="flex justify-end gap-3">
                            <x-basics.button wire:click="receive" variant="success" class="w-full" :disabled="$loading">
                                <span x-show="!$wire.loading">
                                    <i class="ph ph-check-circle mr-2"></i>
                                    Recevoir la commande
                                </span>
                                <span x-show="$wire.loading" class="flex items-center justify-center gap-2">
                                    <x-basics.spinner size="sm" variant="primary" />
                                    Traitement...
                                </span>
                            </x-basics.button>
                        </div>
                    @endslot
                </x-basics.modal>
            </x-basics.card>


        </div>
    </div>
</div>
