<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport Intelligence d'Affaires - Impression</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            background-color: #ffffff;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid: #8b5cf6;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #7c3aed;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #8b5cf6;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #8b5cf6;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #7c3aed;
            width: 50%;
        }
        
        .metric-table td {
            font-weight: 600;
            color: #7c3aed;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: 600;
        }
        
        .badge-success {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .badge-warning {
            background-color: #fef3c7;
            color: #92400e;
        }
        
        .badge-danger {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e2e8f0;
            text-align: center;
            color: #6b7280;
            font-size: 10px;
        }
        
        @media print {
            body {
                padding: 10px;
            }
            
            .no-print {
                display: none !important;
            }
            
            .section {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
        }
        
        @media screen {
            .print-button {
                position: fixed;
                top: 20px;
                right: 20px;
                padding: 12px 24px;
                background-color: #8b5cf6;
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 14px;
                font-weight: 600;
                cursor: pointer;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                z-index: 1000;
            }
            
            .print-button:hover {
                background-color: #7c3aed;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <button onclick="window.print()" class="print-button no-print">
        <i class="ph ph-printer"></i> Imprimer
    </button>

    <!-- Header -->
    <div class="header">
        <h1>RAPPORT D'INTELLIGENCE D'AFFAIRES</h1>
        <div class="period">
            Période : {{ $dateFrom->format('d/m/Y') }} - {{ $dateTo->format('d/m/Y') }}
        </div>
        <div class="generated">
            Généré le {{ now()->format('d/m/Y à H:i') }}
        </div>
    </div>

    <!-- Financial Overview -->
    <div class="section">
        <div class="section-header">VUE D'ENSEMBLE FINANCIÈRE</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Revenu total</th>
                        <td class="text-right">{{ number_format($financialOverview['total_revenue'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Dépenses totales</th>
                        <td class="text-right">{{ number_format($financialOverview['total_expenses'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Coût des marchandises vendues</th>
                        <td class="text-right">{{ number_format($financialOverview['cost_of_goods_sold'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Profit brut</th>
                        <td class="text-right">
                            <span class="badge {{ $financialOverview['gross_profit'] >= 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ number_format($financialOverview['gross_profit'], 0, ',', ' ') }} FC
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Marge de profit brut</th>
                        <td class="text-right">{{ number_format($financialOverview['gross_profit_margin'], 2) }}%</td>
                    </tr>
                    <tr>
                        <th>Profit net</th>
                        <td class="text-right">
                            <span class="badge {{ $financialOverview['net_profit'] >= 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ number_format($financialOverview['net_profit'], 0, ',', ' ') }} FC
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Marge de profit net</th>
                        <td class="text-right">{{ number_format($financialOverview['net_profit_margin'], 2) }}%</td>
                    </tr>
                    <tr>
                        <th>Croissance des revenus</th>
                        <td class="text-right">
                            <span class="badge {{ $financialOverview['revenue_growth'] >= 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ $financialOverview['revenue_growth'] >= 0 ? '+' : '' }}{{ number_format($financialOverview['revenue_growth'], 2) }}%
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Sales Performance -->
    <div class="section">
        <div class="section-header">PERFORMANCE DES VENTES</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Nombre total de ventes</th>
                        <td class="text-right">{{ number_format($salesPerformance['total_sales']) }}</td>
                    </tr>
                    <tr>
                        <th>Valeur moyenne de commande</th>
                        <td class="text-right">{{ number_format($salesPerformance['average_order_value'], 0, ',', ' ') }} FC</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Customer Insights -->
    <div class="section">
        <div class="section-header">APERÇU DES CLIENTS</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Total des clients</th>
                        <td class="text-right">{{ number_format($customerInsights['total_customers']) }}</td>
                    </tr>
                    <tr>
                        <th>Clients actifs</th>
                        <td class="text-right">{{ number_format($customerInsights['active_customers']) }}</td>
                    </tr>
                    <tr>
                        <th>Nouveaux clients</th>
                        <td class="text-right">
                            <span class="badge badge-success">{{ number_format($customerInsights['new_customers']) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Valeur vie client</th>
                        <td class="text-right">{{ number_format($customerInsights['customer_lifetime_value'], 0, ',', ' ') }} FC</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Inventory Insights -->
    <div class="section">
        <div class="section-header">APERÇU DE L'INVENTAIRE</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Total des produits</th>
                        <td class="text-right">{{ number_format($inventoryInsights['total_products']) }}</td>
                    </tr>
                    <tr>
                        <th>Valeur de l'inventaire</th>
                        <td class="text-right">{{ number_format($inventoryInsights['total_inventory_value'], 0, ',', ' ') }} FC</td>
                    </tr>
                    <tr>
                        <th>Produits à stock faible</th>
                        <td class="text-right">
                            <span class="badge badge-warning">{{ number_format($inventoryInsights['low_stock_products']) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Produits en rupture</th>
                        <td class="text-right">
                            <span class="badge badge-danger">{{ number_format($inventoryInsights['out_of_stock_products']) }}</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Operational Metrics -->
    <div class="section">
        <div class="section-header">MÉTRIQUES OPÉRATIONNELLES</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Total des fournisseurs</th>
                        <td class="text-right">{{ number_format($operationalMetrics['total_suppliers']) }}</td>
                    </tr>
                    <tr>
                        <th>Fournisseurs actifs</th>
                        <td class="text-right">{{ number_format($operationalMetrics['active_suppliers']) }}</td>
                    </tr>
                    <tr>
                        <th>Commandes d'achat</th>
                        <td class="text-right">{{ number_format($operationalMetrics['total_purchase_orders']) }}</td>
                    </tr>
                    <tr>
                        <th>Commandes complétées</th>
                        <td class="text-right">{{ number_format($operationalMetrics['completed_purchase_orders']) }}</td>
                    </tr>
                    <tr>
                        <th>Total des dettes</th>
                        <td class="text-right">
                            <span class="badge badge-warning">{{ number_format($operationalMetrics['total_debts'], 0, ',', ' ') }} FC</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Dettes en attente</th>
                        <td class="text-right">
                            <span class="badge badge-danger">{{ number_format($operationalMetrics['pending_debts'], 0, ',', ' ') }} FC</span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Risk Assessment -->
    <div class="section">
        <div class="section-header">ÉVALUATION DES RISQUES</div>
        <div class="section-content">
            <table class="metric-table">
                <tbody>
                    <tr>
                        <th>Ratio dette/revenu</th>
                        <td class="text-right">
                            <span class="badge {{ $riskAssessment['debt_to_revenue_ratio'] < 30 ? 'badge-success' : ($riskAssessment['debt_to_revenue_ratio'] < 60 ? 'badge-warning' : 'badge-danger') }}">
                                {{ number_format($riskAssessment['debt_to_revenue_ratio'], 2) }}%
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Risque d'inventaire (ruptures)</th>
                        <td class="text-right">
                            <span class="badge {{ $riskAssessment['inventory_risk'] == 0 ? 'badge-success' : 'badge-danger' }}">
                                {{ number_format($riskAssessment['inventory_risk']) }} produits
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Risque de stock faible</th>
                        <td class="text-right">
                            <span class="badge {{ $riskAssessment['low_stock_risk'] < 5 ? 'badge-success' : 'badge-warning' }}">
                                {{ number_format($riskAssessment['low_stock_risk']) }} produits
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Rapport généré automatiquement par le système de gestion</p>
        <p>{{ config('app.name') }} - {{ now()->year }}</p>
    </div>

    <script>
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>
