<div>
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Intelligence d\'Inventaire' => route('reports.inventory-intelligence'),
            'Guide d\'interprétation' => null,
        ]" />

    <div class="mt-6 space-y-6">
        <!-- Introduction -->
        <x-basics.card title="🧠 Guide d'Interprétation - Intelligence d'Inventaire"
            subtitle="Comprendre et utiliser efficacement votre rapport d'intelligence d'inventaire">
            <div class="prose max-w-none">
                <p class="text-gray-700">
                    Le rapport d'Intelligence d'Inventaire vous donne une analyse approfondie de votre stock. 
                    Ce guide vous aidera à interpréter les différentes métriques et à optimiser votre gestion 
                    d'inventaire pour maximiser la rentabilité.
                </p>
            </div>
        </x-basics.card>

        <!-- Inventory Overview -->
        <x-basics.card title="📦 Vue d'Ensemble de l'Inventaire" subtitle="Comprendre les métriques principales">
            <div class="space-y-4">
                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Inventaire</h4>
                    <p class="text-sm text-gray-700">
                        La valeur totale de votre stock basée sur les prix d'achat. 
                        Représente le capital immobilisé dans votre inventaire.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Valeur totale des stocks disponibles (stock × prix d'achat)</p>
                    </div>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Santé du Stock</h4>
                    <p class="text-sm text-gray-700">
                        Le pourcentage de produits avec un stock sain (ni faible ni en rupture). 
                        Un pourcentage élevé indique une excellente gestion de stock.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> produits_sains ÷ produits_totaux × 100</p>
                        <p><strong>Stock faible :</strong> stock strictement > 0 et ≤ 10</p>
                        <p><strong>Rupture :</strong> stock = 0</p>
                        <p><strong>Produits sains :</strong> max(0, produits_totaux − stock_faible − ruptures)</p>
                        <p><strong>Borne :</strong> le pourcentage est limité entre 0 et 100</p>
                    </div>
                </div>

                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Faible</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec un stock ≤ 10 unités nécessitant un réapprovisionnement. 
                        Ces produits risquent de tomber en rupture.
                    </p>
                    <p class="text-xs text-orange-600 mt-1">
                        ⚠️ Action recommandée: Planifiez un réapprovisionnement rapidement.
                    </p>
                </div>

                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Rupture de Stock</h4>
                    <p class="text-sm text-gray-700">
                        Produits complètement épuisés (stock = 0). 
                        Ces produits représentent des ventes perdues.
                    </p>
                    <p class="text-xs text-red-600 mt-1">
                        🚨 Action urgente: Réapprovisionnez immédiatement si la demande existe.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Stock Analysis -->
        <x-basics.card title="📊 Analyse des Stocks" subtitle="Comprendre les niveaux de stock">
            <div class="space-y-4">
                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Rupture</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec stock = 0. Action immédiate requise pour éviter 
                        la perte de ventes et la frustration des clients.
                    </p>
                </div>

                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Faible</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec stock entre 1-10 unités. Nécessitent un 
                        réapprovisionnement dans les prochains jours.
                    </p>
                </div>

                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Normal</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec stock entre 11-50 unités. Niveau de stock 
                        optimal pour la plupart des produits.
                    </p>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Stock Élevé</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec stock entre 51-100 unités. Bon niveau 
                        pour les produits à forte demande.
                    </p>
                </div>

                <div class="border-l-4 border-purple-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Surstock</h4>
                    <p class="text-sm text-gray-700">
                        Produits avec stock > 100 unités. Considérez des promotions 
                        ou réduisez les commandes futures.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Product Performance -->
        <x-basics.card title="🏆 Performance des Produits" subtitle="Identifier vos meilleurs produits">
            <div class="space-y-4">
                <div class="border-l-4 border-yellow-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Top Produits</h4>
                    <p class="text-sm text-gray-700">
                        Les produits les plus vendus par quantité dans la période. 
                        Identifiez vos produits stars pour optimiser leur disponibilité.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Utilisation :</strong> Produits les plus vendus par quantité dans la période</p>
                    </div>
                </div>

                <div class="border-l-4 border-teal-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Quantité Vendue</h4>
                    <p class="text-sm text-gray-700">
                        Le nombre total d'unités vendues pour chaque produit. 
                        Indique la popularité et la demande.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Nombre total d'unités vendues</p>
                    </div>
                </div>

                <div class="border-l-4 border-cyan-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Chiffre d'Affaires</h4>
                    <p class="text-sm text-gray-700">
                        Le montant total généré par chaque produit. 
                        Montre quels produits contribuent le plus aux revenus.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (quantité × prix_unitaire)</p>
                    </div>
                </div>

                <div class="border-l-4 border-lime-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Prix Moyen</h4>
                    <p class="text-sm text-gray-700">
                        Le prix moyen auquel chaque produit est vendu. 
                        Aide à comprendre la stratégie de prix et la valeur perçue.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> revenu_total ÷ quantité_totale</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- ABC Analysis -->
        <x-basics.card title="📈 Analyse ABC" subtitle="Prioriser vos produits selon leur importance">
            <div class="space-y-4">
                <div class="border-l-4 border-red-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Classe A (80%)</h4>
                    <p class="text-sm text-gray-700">
                        Produits générant ~80% des revenus. Priorité maximale pour 
                        la gestion du stock et la disponibilité.
                    </p>
                    <p class="text-xs text-red-600 mt-1">
                        🎯 Stratégie: Maintenez toujours un stock élevé, suivez de près.
                    </p>
                </div>

                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Classe B (15%)</h4>
                    <p class="text-sm text-gray-700">
                        Produits générant ~15% des revenus. Priorité moyenne 
                        avec un suivi régulier.
                    </p>
                    <p class="text-xs text-orange-600 mt-1">
                        📊 Stratégie: Suivi modéré, stock moyen à élevé.
                    </p>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Classe C (5%)</h4>
                    <p class="text-sm text-gray-700">
                        Produits générant ~5% des revenus. Priorité faible, 
                        gestion simplifiée possible.
                    </p>
                    <p class="text-xs text-green-600 mt-1">
                        💡 Stratégie: Stock minimum, commandes moins fréquentes.
                    </p>
                </div>

                <div class="bg-gray-50 border border-gray-200 rounded-lg p-4 mt-4">
                    <h5 class="font-semibold text-gray-800 mb-2">📋 Méthode de Calcul</h5>
                    <div class="text-xs text-gray-600 space-y-1">
                        <p><strong>Étape 1 :</strong> Tri par revenus décroissants</p>
                        <p><strong>Étape 2 :</strong> Calcul du cumul des pourcentages</p>
                        <p><strong>Étape 3 :</strong> Classification : A ≤ 80%, B ≤ 95%, C > 95%</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Category Insights -->
        <x-basics.card title="🏷️ Insights par Catégorie" subtitle="Analyser les performances par catégorie">
            <div class="space-y-4">
                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Stock Catégorie</h4>
                    <p class="text-sm text-gray-700">
                        La valeur totale du stock pour chaque catégorie. 
                        Aide à comprendre où est investi votre capital.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (stock × prix d'achat) par catégorie</p>
                    </div>
                </div>

                <div class="border-l-4 border-pink-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Santé Stock Catégorie</h4>
                    <p class="text-sm text-gray-700">
                        Le pourcentage de produits sains dans chaque catégorie. 
                        Identifie les catégories nécessitant une attention.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Calcul :</strong> Pourcentage de produits sains dans la catégorie</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Rotation & Costs -->
        <x-basics.card title="🔄 Rotation & Coûts" subtitle="Comprendre les métriques de rotation">
            <div class="space-y-4">
                <div class="border-l-4 border-blue-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">COGS (Coût des Ventes)</h4>
                    <p class="text-sm text-gray-700">
                        Le coût total des marchandises vendues. Représente ce que vous 
                        avez dépensé pour les produits vendus.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> Σ (quantité × coût_unitaire_au_moment_de_la_vente)</p>
                    </div>
                </div>

                <div class="border-l-4 border-green-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Valeur Moyenne d'Inventaire</h4>
                    <p class="text-sm text-gray-700">
                        La valeur moyenne de votre inventaire sur la période. 
                        Base pour calculer la rotation des stocks.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> moyenne de (stock × prix d'achat) sur les produits</p>
                    </div>
                </div>

                <div class="border-l-4 border-purple-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Rotation des Stocks</h4>
                    <p class="text-sm text-gray-700">
                        Indique combien de fois votre inventaire se renouvelle par an. 
                        Une rotation élevée est généralement positive.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> COGS ÷ valeur_moyenne_d'inventaire</p>
                        <p><strong>Interprétation :</strong> Plus élevé = meilleure efficacité</p>
                    </div>
                </div>

                <div class="border-l-4 border-orange-500 pl-4 py-2">
                    <h4 class="font-semibold text-gray-900 mb-1">Jours en Stock</h4>
                    <p class="text-sm text-gray-700">
                        Nombre moyen de jours qu'un produit reste en stock avant d'être vendu. 
                        Aide à planifier les commandes.
                    </p>
                    <div class="mt-2 text-xs text-gray-600 bg-gray-50 p-3 rounded">
                        <p><strong>Formule :</strong> 365 ÷ rotation (si rotation > 0)</p>
                        <p><strong>Interprétation :</strong> Moins de jours = meilleure rotation</p>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Formula Summary -->
        <x-basics.card title="📋 Récapitulatif des Formules" subtitle="Référence rapide des calculs">
            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span class="font-medium">Santé du Stock (%):</span>
                        <span class="text-gray-600">(produits_sains ÷ produits_totaux) × 100</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">Produits sains:</span>
                        <span class="text-gray-600">max(0, total − faibles − ruptures)</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">Revenu (produit):</span>
                        <span class="text-gray-600">Σ (quantité × prix)</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">Prix moyen (produit):</span>
                        <span class="text-gray-600">revenu ÷ quantité</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">COGS:</span>
                        <span class="text-gray-600">Σ (quantité × coût_vente)</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">Rotation:</span>
                        <span class="text-gray-600">COGS ÷ valeur_moyenne_inventaire</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="font-medium">Jours en stock:</span>
                        <span class="text-gray-600">365 ÷ rotation (si rotation > 0)</span>
                    </div>
                </div>
            </div>
        </x-basics.card>

        <!-- Best Practices -->
        <x-basics.card title="✨ Bonnes Pratiques" subtitle="Optimiser votre gestion d'inventaire">
            <div class="space-y-3">
                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Surveillez la santé du stock :</strong> Maintenez un pourcentage 
                        élevé de produits sains pour éviter les ruptures.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Priorisez selon l'ABC :</strong> Concentrez vos efforts sur les 
                        produits de classe A qui génèrent 80% des revenus.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Optimisez la rotation :</strong> Une rotation élevée avec des jours 
                        en stock faibles indique une gestion efficace.
                    </p>
                </div>

                <div class="flex items-start gap-2">
                    <i class="ph ph-check-circle text-green-600 text-xl mt-0.5"></i>
                    <p class="text-sm text-gray-700">
                        <strong>Analysez par catégorie :</strong> Identifiez les catégories 
                        problématiques pour une action ciblée.
                    </p>
                </div>
            </div>
        </x-basics.card>

        <!-- Actions -->
        <x-basics.card title="⚡ Actions Recommandées" subtitle="Que faire avec ces informations?">
            <div class="space-y-4">
                <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                    <h4 class="font-semibold text-red-900 mb-2">Pour les produits en rupture :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-red-800">
                        <li>Contactez immédiatement le fournisseur pour passer commande</li>
                        <li>Priorisez les produits de classe A en rupture</li>
                        <li>Informez vos clients réguliers du délai de réapprovisionnement</li>
                    </ul>
                </div>

                <div class="bg-orange-50 border border-orange-200 rounded-lg p-4">
                    <h4 class="font-semibold text-orange-900 mb-2">Pour les stocks faibles :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-orange-800">
                        <li>Planifiez une commande dans les prochains jours</li>
                        <li>Concentrez-vous d'abord sur les produits de classe A</li>
                        <li>Vérifiez les ventes récentes pour ajuster la quantité</li>
                    </ul>
                </div>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <h4 class="font-semibold text-blue-900 mb-2">Pour les surstocks :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-blue-800">
                        <li>Envisagez des promotions pour les produits à rotation lente</li>
                        <li>Réduisez les commandes futures de ces produits</li>
                        <li>Analysez pourquoi ces produits ne se vendent pas</li>
                    </ul>
                </div>

                <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                    <h4 class="font-semibold text-green-900 mb-2">Pour optimiser l'inventaire :</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm text-green-800">
                        <li>Appliquez la stratégie ABC pour prioriser la gestion</li>
                        <li>Améliorez la rotation des stocks les plus lents</li>
                        <li>Alignez les niveaux de stock avec la demande réelle</li>
                    </ul>
                </div>
            </div>
        </x-basics.card>
    </div>
</div>