<div>
    <div class="container mx-auto" x-data="inventoryIntelligenceDashboard()" x-init="init()">
        <!-- Header -->
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Intelligence d\'Inventaire du ' . ($dateFrom ? \Carbon\Carbon::parse($dateFrom)->format('d/m/Y') : ' - ') . ' au ' . ($dateTo ? \Carbon\Carbon::parse($dateTo)->format('d/m/Y') : ' - ') => null,
        ]">
            <x-slot name="action">
                <x-dashboard.reports.inventory-dropdown :dateFrom="$dateFrom" :dateTo="$dateTo" />
            </x-slot>
        </x-dashboard.breadcrumb>

        <!-- Inventory Overview Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mt-6 mb-8">
            <!-- Total Inventory Value -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-blue-600 text-sm font-medium">Valeur Inventaire</p>
                        <p class="text-xl font-bold text-blue-800">
                            {{ number_format($inventoryOverview['total_inventory_value'], 0, ',', ' ') }}
                            {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                        </p>
                        <p class="text-sm text-gray-600">
                            {{ $inventoryOverview['total_products'] }} produits
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-package text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Stock Health -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-green-600 text-sm font-medium">Santé du Stock</p>
                        <p class="text-xl font-bold text-green-800">
                            {{ $inventoryOverview['stock_health_percentage'] }}%
                        </p>
                        <p class="text-sm text-gray-600">
                            {{ $inventoryOverview['healthy_stock_products'] }} produits sains
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-shield-check text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Low Stock Alert -->
            <div class="bg-gradient-to-br from-orange-50 to-orange-100 border border-orange-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-orange-600 text-sm font-medium">Stock Faible</p>
                        <p class="text-xl font-bold text-orange-800">
                            {{ $inventoryOverview['low_stock_products'] }}
                        </p>
                        <p class="text-sm text-gray-600">
                            Nécessitent réapprovisionnement
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-orange-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-warning text-white text-xl"></i>
                    </div>
                </div>
            </div>

            <!-- Out of Stock -->
            <div class="bg-gradient-to-br from-red-50 to-red-100 border border-red-200 rounded-xl p-6 shadow-sm">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-red-600 text-sm font-medium">Rupture de Stock</p>
                        <p class="text-xl font-bold text-red-800">
                            {{ $inventoryOverview['out_of_stock_products'] }}
                        </p>
                        <p class="text-sm text-gray-600">
                            Produits épuisés
                        </p>
                    </div>
                    <div class="w-12 h-12 bg-red-500 rounded-lg flex items-center justify-center">
                        <i class="ph ph-x-circle text-white text-xl"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Analysis -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-chart-bar text-blue-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Analyse des Stocks</h3>
                        <p class="text-sm text-gray-600">Répartition des produits par niveau de stock</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
                <div class="p-4 bg-red-50 rounded-lg border border-red-200 text-center">
                    <div class="text-2xl font-bold text-red-800">{{ $stockAnalysis['stock_distribution']['out_of_stock'] }}</div>
                    <div class="text-sm text-red-600">Rupture</div>
                </div>
                <div class="p-4 bg-orange-50 rounded-lg border border-orange-200 text-center">
                    <div class="text-2xl font-bold text-orange-800">{{ $stockAnalysis['stock_distribution']['low_stock'] }}</div>
                    <div class="text-sm text-orange-600">Stock Faible</div>
                </div>
                <div class="p-4 bg-green-50 rounded-lg border border-green-200 text-center">
                    <div class="text-2xl font-bold text-green-800">{{ $stockAnalysis['stock_distribution']['normal_stock'] }}</div>
                    <div class="text-sm text-green-600">Stock Normal</div>
                </div>
                <div class="p-4 bg-blue-50 rounded-lg border border-blue-200 text-center">
                    <div class="text-2xl font-bold text-blue-800">{{ $stockAnalysis['stock_distribution']['high_stock'] }}</div>
                    <div class="text-sm text-blue-600">Stock Élevé</div>
                </div>
                <div class="p-4 bg-purple-50 rounded-lg border border-purple-200 text-center">
                    <div class="text-2xl font-bold text-purple-800">{{ $stockAnalysis['stock_distribution']['overstock'] }}</div>
                    <div class="text-sm text-purple-600">Surstock</div>
                </div>
            </div>
        </x-basics.card>

        <!-- Product Performance -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-trophy text-green-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Performance des Produits</h3>
                        <p class="text-sm text-gray-600">Top 10 des produits les plus vendus</p>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Produit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Quantité Vendue</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Chiffre d'Affaires</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Stock Actuel</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($productPerformance['top_selling_products'] as $product)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-lg bg-gray-200 flex items-center justify-center">
                                            <i class="ph ph-package text-gray-500"></i>
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">{{ $product['product']->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $product['product']->category->name ?? 'Sans catégorie' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ number_format($product['total_quantity'], 0, ',', ' ') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ number_format($product['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    @if($product['product']->current_stock == 0) bg-red-100 text-red-800
                                    @elseif($product['product']->current_stock <= 10) bg-orange-100 text-orange-800
                                    @else bg-green-100 text-green-800 @endif">
                                    {{ $product['product']->current_stock }}
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </x-basics.card>

        <!-- ABC Analysis -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-chart-pie text-purple-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Analyse ABC</h3>
                        <p class="text-sm text-gray-600">Classification des produits par importance</p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Class A Products -->
                <div class="p-4 bg-yellow-50 rounded-lg border border-yellow-200">
                    <div class="flex items-center justify-between mb-2">
                        <h4 class="font-medium text-yellow-800">Classe A (80%)</h4>
                        <span class="text-sm text-yellow-600">{{ $abcAnalysis['A']['count'] }} produits</span>
                    </div>
                    <p class="text-2xl font-bold text-yellow-800">
                        {{ number_format($abcAnalysis['A']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                    </p>
                    <p class="text-sm text-yellow-600 mt-1">Produits prioritaires</p>
                </div>

                <!-- Class B Products -->
                <div class="p-4 bg-blue-50 rounded-lg border border-blue-200">
                    <div class="flex items-center justify-between mb-2">
                        <h4 class="font-medium text-blue-800">Classe B (15%)</h4>
                        <span class="text-sm text-blue-600">{{ $abcAnalysis['B']['count'] }} produits</span>
                    </div>
                    <p class="text-2xl font-bold text-blue-800">
                        {{ number_format($abcAnalysis['B']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                    </p>
                    <p class="text-sm text-blue-600 mt-1">Produits importants</p>
                </div>

                <!-- Class C Products -->
                <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                    <div class="flex items-center justify-between mb-2">
                        <h4 class="font-medium text-gray-800">Classe C (5%)</h4>
                        <span class="text-sm text-gray-600">{{ $abcAnalysis['C']['count'] }} produits</span>
                    </div>
                    <p class="text-2xl font-bold text-gray-800">
                        {{ number_format($abcAnalysis['C']['revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                    </p>
                    <p class="text-sm text-gray-600 mt-1">Produits secondaires</p>
                </div>
            </div>
        </x-basics.card>

        <!-- Category Insights -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-tag text-indigo-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Insights par Catégorie</h3>
                        <p class="text-sm text-gray-600">Analyse des stocks par catégorie de produits</p>
                    </div>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Catégorie</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Produits</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Valeur Stock</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Santé Stock</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($categoryInsights as $category)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $category['category']->name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $category['total_products'] }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ number_format($category['total_inventory_value'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                    @if($category['stock_health_percentage'] >= 80) bg-green-100 text-green-800
                                    @elseif($category['stock_health_percentage'] >= 60) bg-yellow-100 text-yellow-800
                                    @else bg-red-100 text-red-800 @endif">
                                    {{ $category['stock_health_percentage'] }}%
                                </span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </x-basics.card>

        <!-- Strategic Insights -->
        <x-basics.card class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center">
                        <i class="ph ph-lightbulb text-red-600 text-lg"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">Insights Stratégiques</h3>
                        <p class="text-sm text-gray-600">Recommandations et alertes importantes</p>
                    </div>
                </div>
            </div>

            <div class="space-y-4">
                @foreach($strategicInsights as $insight)
                <div class="p-4 rounded-lg border @if($insight['type'] === 'success') bg-green-50 border-green-200 @elseif($insight['type'] === 'warning') bg-yellow-50 border-yellow-200 @elseif($insight['type'] === 'danger') bg-red-50 border-red-200 @else bg-blue-50 border-blue-200 @endif">
                    <div class="flex items-start gap-3">
                        <div class="w-8 h-8 rounded-lg flex items-center justify-center @if($insight['type'] === 'success') bg-green-100 @elseif($insight['type'] === 'warning') bg-yellow-100 @elseif($insight['type'] === 'danger') bg-red-100 @else bg-blue-100 @endif">
                            @if($insight['type'] === 'success')
                                <i class="ph ph-check-circle text-green-600"></i>
                            @elseif($insight['type'] === 'warning')
                                <i class="ph ph-warning text-yellow-600"></i>
                            @elseif($insight['type'] === 'danger')
                                <i class="ph ph-x-circle text-red-600"></i>
                            @else
                                <i class="ph ph-info text-blue-600"></i>
                            @endif
                        </div>
                        <div>
                            <h4 class="font-semibold text-gray-900">{{ $insight['title'] }}</h4>
                            <p class="text-sm text-gray-600 mt-1">{{ $insight['message'] }}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </x-basics.card>
    </div>
</div>

