<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport de Performance des Ventes</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
            background-color: #ffffff;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #3b82f6;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #1e40af;
            font-size: 24px;
            margin: 0 0 10px 0;
            font-weight: bold;
        }
        
        .header .period {
            color: #6b7280;
            font-size: 14px;
            margin: 5px 0;
            font-weight: 500;
        }
        
        .header .generated {
            color: #9ca3af;
            font-size: 11px;
        }
        
        .section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .section-header {
            background-color: #3b82f6;
            color: white;
            padding: 10px 15px;
            margin: 0 0 0 0;
            font-size: 14px;
            font-weight: bold;
        }
        
        .section-content {
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0;
            background-color: white;
        }
        
        th, td {
            padding: 10px 12px;
            text-align: left;
            border: 1px solid #e2e8f0;
            font-size: 11px;
        }
        
        th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        td {
            color: #1e293b;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:nth-child(odd) {
            background-color: #ffffff;
        }
        
        .metric-table {
            margin-bottom: 20px;
        }
        
        .metric-table th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .metric-table td {
            text-align: center;
            font-weight: bold;
        }
        
        .metric-table .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .metric-table .metric-value {
            font-size: 12px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .status-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 9px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .status-positive {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .status-negative {
            background-color: #fecaca;
            color: #991b1b;
        }
        
        .status-neutral {
            background-color: #f3f4f6;
            color: #374151;
        }
        
        .status-good {
            background-color: #dcfce7;
            color: #166534;
        }
        
        .status-weak {
            background-color: #fecaca;
            color: #991b1b;
        }
        
        .financial-overview {
            margin-bottom: 20px;
        }
        
        .financial-overview th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .financial-overview td {
            text-align: center;
            font-weight: bold;
            font-size: 12px;
        }
        
        .financial-overview .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .financial-overview .metric-value {
            font-size: 13px;
            font-weight: bold;
            color: #1e293b;
        }
        
        .trend-analysis {
            margin-bottom: 20px;
        }
        
        .trend-analysis th {
            background-color: #3b82f6;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        
        .trend-analysis td {
            text-align: center;
        }
        
        .trend-analysis .metric-label {
            text-align: left;
            font-weight: normal;
        }
        
        .trend-analysis .growth-positive {
            color: #059669;
            font-weight: bold;
        }
        
        .trend-analysis .growth-negative {
            color: #dc2626;
            font-weight: bold;
        }
        
        .trend-analysis .growth-neutral {
            color: #6b7280;
            font-weight: bold;
        }
        
        .recommendations {
            margin-top: 20px;
            padding: 15px;
            background-color: #fef2f2;
            border-left: 4px solid #dc2626;
            border-radius: 4px;
        }
        
        .recommendations h4 {
            color: #dc2626;
            margin: 0 0 8px 0;
            font-size: 12px;
            font-weight: bold;
        }
        
        .recommendations p {
            color: #7f1d1d;
            margin: 0;
            font-size: 11px;
            line-height: 1.4;
        }
        
        .empty-data {
            text-align: center;
            color: #9ca3af;
            font-style: italic;
            padding: 20px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>Rapport de Performance des Ventes</h1>
        <div class="period">Période: {{ \Carbon\Carbon::parse($dateFrom)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($dateTo)->format('d/m/Y') }}</div>
        <div class="generated">Généré le: {{ \Carbon\Carbon::now()->format('d/m/Y à H:i') }}</div>
    </div>

    <!-- Aperçu Financier -->
    <div class="section">
        <div class="section-header">Aperçu Financier</div>
        <div class="section-content">
            <table class="financial-overview">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Revenus Totaux</td>
                        <td class="metric-value">{{ number_format($salesSummary['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Nombre Total de Ventes</td>
                        <td class="metric-value">{{ number_format($salesSummary['total_sales'], 0, ',', ' ') }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Vente Moyenne</td>
                        <td class="metric-value">{{ number_format($salesSummary['average_sale'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                    </tr>
                    <tr>
                        <td class="metric-label">Clients Actifs</td>
                        <td class="metric-value">{{ number_format($customerMetrics['active_customers'], 0, ',', ' ') }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Analyse des Tendances -->
    <div class="section">
        <div class="section-header">Analyse des Tendances</div>
        <div class="section-content">
            <table class="trend-analysis">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Période Actuelle</th>
                        <th>Période Précédente</th>
                        <th>Croissance</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Revenus</td>
                        <td>{{ number_format($salesSummary['total_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td>{{ number_format($salesSummary['previous_revenue'], 0, ',', ' ') }} {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td class="{{ $salesSummary['revenue_growth'] >= 0 ? 'growth-positive' : 'growth-negative' }}">
                            {{ $salesSummary['revenue_growth'] >= 0 ? '+' : '' }}{{ $salesSummary['revenue_growth'] }}%
                        </td>
                    </tr>
                    <tr>
                        <td class="metric-label">Nombre de Ventes</td>
                        <td>{{ number_format($salesSummary['total_sales'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($salesSummary['previous_sales'], 0, ',', ' ') }}</td>
                        <td class="{{ $salesSummary['sales_growth'] >= 0 ? 'growth-positive' : 'growth-negative' }}">
                            {{ $salesSummary['sales_growth'] >= 0 ? '+' : '' }}{{ $salesSummary['sales_growth'] }}%
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Top 10 Produits -->
    <div class="section">
        <div class="section-header">Top 10 Produits</div>
        <div class="section-content">
            @if($topProducts->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Produit</th>
                        <th>Catégorie</th>
                        <th>Quantité Vendue</th>
                        <th>Chiffre d'Affaires ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($topProducts as $product)
                    <tr>
                        <td>{{ $product['product']->name }}</td>
                        <td>{{ $product['product']->category->name ?? 'Sans catégorie' }}</td>
                        <td>{{ number_format($product['total_quantity'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($product['total_revenue'], 0, ',', ' ') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucun produit vendu dans cette période</div>
            @endif
        </div>
    </div>

    <!-- Performance des Vendeurs -->
    <div class="section">
        <div class="section-header">Performance des Vendeurs</div>
        <div class="section-content">
            @if($salesByUser->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Vendeur</th>
                        <th>Nombre de Ventes</th>
                        <th>Chiffre d'Affaires ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                        <th>Vente Moyenne ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($salesByUser as $userSales)
                    <tr>
                        <td>{{ $userSales['user']->firstname }} {{ $userSales['user']->lastname }}</td>
                        <td>{{ number_format($userSales['sales_count'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($userSales['total_revenue'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($userSales['average_sale'], 0, ',', ' ') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucune vente enregistrée dans cette période</div>
            @endif
        </div>
    </div>

    <!-- Revenus par Méthode de Paiement -->
    <div class="section">
        <div class="section-header">Revenus par Méthode de Paiement</div>
        <div class="section-content">
            @if($revenueByPaymentMethod->where('total_revenue', '>', 0)->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Méthode de Paiement</th>
                        <th>Nombre de Transactions</th>
                        <th>Montant Total ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                        <th>Pourcentage</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($revenueByPaymentMethod->where('total_revenue', '>', 0) as $payment)
                    <tr>
                        <td>{{ $payment['payment_method_name'] }}</td>
                        <td>{{ number_format($payment['total_orders'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($payment['total_revenue'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($payment['percentage'], 1) }}%</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucune transaction enregistrée dans cette période</div>
            @endif
        </div>
    </div>

    <!-- Ventes par Type -->
    <div class="section">
        <div class="section-header">Ventes par Type</div>
        <div class="section-content">
            @if($salesByType->where('total_revenue', '>', 0)->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th>Type de Vente</th>
                        <th>Nombre de Ventes</th>
                        <th>Montant Total ({{ \App\Models\Setting::DEFAULT_CURRENCY }})</th>
                        <th>Pourcentage</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($salesByType->where('total_revenue', '>', 0) as $type)
                    <tr>
                        <td>{{ $type['sale_type_name'] }}</td>
                        <td>{{ number_format($type['total_orders'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($type['total_revenue'], 0, ',', ' ') }}</td>
                        <td>{{ number_format($type['percentage'], 1) }}%</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <div class="empty-data">Aucune vente par type enregistrée dans cette période</div>
            @endif
        </div>
    </div>

    <!-- Analyse des Clients -->
    <div class="section">
        <div class="section-header">Analyse des Clients</div>
        <div class="section-content">
            <table class="metric-table">
                <thead>
                    <tr>
                        <th>Métrique</th>
                        <th>Valeur</th>
                        <th>Statut</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="metric-label">Total Clients</td>
                        <td class="metric-value">{{ number_format($customerMetrics['total_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-neutral">-</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Nouveaux Clients</td>
                        <td class="metric-value">{{ number_format($customerMetrics['new_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Clients Actifs</td>
                        <td class="metric-value">{{ number_format($customerMetrics['active_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Clients Récurrents</td>
                        <td class="metric-value">{{ number_format($customerMetrics['repeat_customers'], 0, ',', ' ') }}</td>
                        <td><span class="status-badge status-positive">Positif</span></td>
                    </tr>
                    <tr>
                        <td class="metric-label">Taux de Rétention</td>
                        <td class="metric-value">{{ number_format($customerMetrics['customer_retention_rate'], 1) }}%</td>
                        <td><span class="status-badge {{ $customerMetrics['customer_retention_rate'] >= 50 ? 'status-good' : 'status-weak' }}">
                            {{ $customerMetrics['customer_retention_rate'] >= 50 ? 'Bon' : 'Faible' }}
                        </span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Recommandations -->
    <div class="recommendations">
        <h4>Recommandations</h4>
        <p>
            @if($salesSummary['revenue_growth'] < 0)
                <strong>Préoccupations de Performance:</strong> Les revenus ont diminué de {{ abs($salesSummary['revenue_growth']) }}% par rapport à la période précédente. 
                Analysez les tendances de vente et considérez des stratégies de relance.
            @elseif($salesSummary['revenue_growth'] > 20)
                <strong>Excellente Performance:</strong> Croissance remarquable de {{ $salesSummary['revenue_growth'] }}%. 
                Maintenez cette dynamique et explorez des opportunités d'expansion.
            @else
                <strong>Performance Stable:</strong> Croissance modérée de {{ $salesSummary['revenue_growth'] }}%. 
                Continuez à optimiser les processus de vente et à fidéliser les clients.
            @endif
        </p>
    </div>

    <!-- Guide d'Interprétation -->
    <div class="section">
        <div class="section-header">Guide d'Interprétation des Métriques</div>
        <div class="section-content">
            <div style="padding: 20px; background-color: #f8fafc; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">📊 Aperçu Financier</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Revenus Totaux:</strong> Montant total généré par toutes les ventes dans la période sélectionnée</li>
                    <li><strong>Nombre Total de Ventes:</strong> Nombre de transactions complétées avec succès</li>
                    <li><strong>Vente Moyenne:</strong> Montant moyen par transaction (Revenus Totaux ÷ Nombre de Ventes)</li>
                    <li><strong>Clients Actifs:</strong> Nombre de clients ayant effectué au moins une commande dans la période</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f0f9ff; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">📈 Analyse des Tendances</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Période Actuelle:</strong> Données de la période sélectionnée pour le rapport</li>
                    <li><strong>Période Précédente:</strong> Données de la période équivalente précédente pour comparaison</li>
                    <li><strong>Croissance:</strong> Pourcentage de variation entre les deux périodes (positif = amélioration, négatif = baisse)</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f0fdf4; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">🏆 Top 10 Produits</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Produit:</strong> Nom du produit vendu</li>
                    <li><strong>Catégorie:</strong> Classification du produit dans votre catalogue</li>
                    <li><strong>Quantité Vendue:</strong> Nombre total d'unités vendues</li>
                    <li><strong>Chiffre d'Affaires:</strong> Montant total généré par ce produit</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fefce8; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">👥 Performance des Vendeurs</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Vendeur:</strong> Nom de l'employé responsable des ventes</li>
                    <li><strong>Nombre de Ventes:</strong> Quantité de transactions réalisées par ce vendeur</li>
                    <li><strong>Chiffre d'Affaires:</strong> Montant total généré par ce vendeur</li>
                    <li><strong>Vente Moyenne:</strong> Montant moyen par transaction pour ce vendeur</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fdf2f8; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">💳 Revenus par Méthode de Paiement</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Méthode de Paiement:</strong> Type de paiement utilisé (Espèces, Carte, Mobile Money, etc.)</li>
                    <li><strong>Nombre de Transactions:</strong> Quantité de ventes effectuées avec cette méthode</li>
                    <li><strong>Montant Total:</strong> Somme totale collectée via cette méthode</li>
                    <li><strong>Pourcentage:</strong> Part de cette méthode dans le chiffre d'affaires total</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #f3e8ff; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">🏷️ Ventes par Type</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Type de Vente:</strong> Classification de la transaction (Ordonnance, Libre-service, Gros, etc.)</li>
                    <li><strong>Nombre de Ventes:</strong> Quantité de transactions de ce type</li>
                    <li><strong>Montant Total:</strong> Chiffre d'affaires généré par ce type de vente</li>
                    <li><strong>Pourcentage:</strong> Part de ce type dans le chiffre d'affaires total</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #ecfdf5; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">👤 Analyse des Clients</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Total Clients:</strong> Nombre total de clients dans votre base de données</li>
                    <li><strong>Nouveaux Clients:</strong> Clients qui ont effectué leur première commande dans la période</li>
                    <li><strong>Clients Actifs:</strong> Clients ayant effectué au moins une commande dans la période</li>
                    <li><strong>Clients Récurrents:</strong> Clients ayant effectué plus d'une commande dans la période</li>
                    <li><strong>Taux de Rétention:</strong> Pourcentage de clients qui reviennent (Clients Récurrents ÷ Clients Actifs × 100)</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fef3c7; border-radius: 8px; margin-bottom: 20px;">
                <h4 style="color: #1e40af; margin: 0 0 15px 0; font-size: 14px; font-weight: bold;">🎯 Indicateurs de Performance</h4>
                <ul style="margin: 0; padding-left: 20px; color: #374151; font-size: 11px; line-height: 1.6;">
                    <li><strong>Statut "Positif":</strong> Indicateur vert - Performance satisfaisante ou en amélioration</li>
                    <li><strong>Statut "Faible":</strong> Indicateur rouge - Performance nécessitant une attention particulière</li>
                    <li><strong>Statut "Bon":</strong> Indicateur vert - Métrique dans une fourchette acceptable</li>
                    <li><strong>Croissance Positive (+):</strong> Amélioration par rapport à la période précédente</li>
                    <li><strong>Croissance Négative (-):</strong> Détérioration par rapport à la période précédente</li>
                </ul>
            </div>

            <div style="padding: 20px; background-color: #fef2f2; border-radius: 8px; border-left: 4px solid #dc2626;">
                <h4 style="color: #dc2626; margin: 0 0 10px 0; font-size: 13px; font-weight: bold;">💡 Comment Utiliser Ce Rapport</h4>
                <ul style="margin: 0; padding-left: 20px; color: #7f1d1d; font-size: 11px; line-height: 1.6;">
                    <li><strong>Analysez les tendances:</strong> Comparez les périodes pour identifier les évolutions</li>
                    <li><strong>Identifiez les opportunités:</strong> Concentrez-vous sur les produits et vendeurs performants</li>
                    <li><strong>Surveillez les alertes:</strong> Portez attention aux indicateurs "Faible" ou négatifs</li>
                    <li><strong>Planifiez les actions:</strong> Utilisez les recommandations pour améliorer les performances</li>
                    <li><strong>Suivez la progression:</strong> Générez ce rapport régulièrement pour suivre l'évolution</li>
                </ul>
            </div>
        </div>
    </div>
</body>
</html>