<div>
    <!-- Header -->
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Rapports' => route('reports.business-intelligence'),
            'Rapport de Stock' => null,
        ]">
        <x-slot name="action">
            <x-dashboard.reports.stock-dropdown :stockStatus="$stock_status" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <!-- Stock Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mt-6 mb-8">
        <!-- Total Products -->
        <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-xl p-6 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-600 text-sm font-medium">Total Produits</p>
                    <p class="text-2xl font-bold text-blue-800">
                        {{ number_format($stockSummary['total_products'], 0, ',', ' ') }}
                    </p>
                    <p class="text-sm text-gray-600">
                        {{ number_format($stockSummary['total_stock_quantity'], 0, ',', ' ') }} unités
                    </p>
                </div>
                <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center">
                    <i class="ph ph-package text-white text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Stock Value -->
        <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-xl p-6 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-600 text-sm font-medium">Valeur du Stock</p>
                    <p class="text-xl font-bold text-green-800">
                        {{ number_format($stockSummary['total_stock_value'], 0, ',', ' ') }}
                        {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                    </p>
                    <p class="text-sm text-gray-600">
                        Moyenne: {{ number_format($stockSummary['average_stock_value'], 0, ',', ' ') }}
                        {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                    </p>
                </div>
                <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="ph ph-currency-circle-dollar text-white text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Low Stock Products -->
        <div class="bg-gradient-to-br from-orange-50 to-orange-100 border border-orange-200 rounded-xl p-6 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-orange-600 text-sm font-medium">Stock Faible</p>
                    <p class="text-2xl font-bold text-orange-800">
                        {{ number_format($stockSummary['low_stock_products'], 0, ',', ' ') }}
                    </p>
                    <p class="text-sm text-gray-600">
                        Nécessite attention
                    </p>
                </div>
                <div class="w-12 h-12 bg-orange-500 rounded-lg flex items-center justify-center">
                    <i class="ph ph-warning text-white text-2xl"></i>
                </div>
            </div>
        </div>

        <!-- Out of Stock Products -->
        <div class="bg-gradient-to-br from-red-50 to-red-100 border border-red-200 rounded-xl p-6 shadow-sm">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-red-600 text-sm font-medium">En Rupture</p>
                    <p class="text-2xl font-bold text-red-800">
                        {{ number_format($stockSummary['out_of_stock_products'], 0, ',', ' ') }}
                    </p>
                    <p class="text-sm text-gray-600">
                        Action requise
                    </p>
                </div>
                <div class="w-12 h-12 bg-red-500 rounded-lg flex items-center justify-center">
                    <i class="ph ph-x-circle text-white text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Products Stock List -->
    <x-basics.card title="Détail du Stock" subtitle="Liste complète des produits avec leur stock">
        @if ($productsStock->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                            <th class="p-3 text-left font-medium text-gray-700">SKU</th>
                            <th class="p-3 text-right font-medium text-gray-700">Stock Actuel</th>
                            <th class="p-3 text-right font-medium text-gray-700">Coût Unitaire</th>
                            <th class="p-3 text-right font-medium text-gray-700">Valeur Stock</th>
                            <th class="p-3 text-center font-medium text-gray-700">Statut</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($productsStock as $product)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-3 py-2 font-medium">
                                    <a href="{{ route('products.show', $product['slug']) }}" wire:navigate
                                        class="text-indigo-600 hover:underline">
                                        {{ $product['name'] }}
                                    </a>
                                </td>
                                <td class="px-3 py-2 text-gray-600 font-mono">{{ $product['sku'] ?? 'N/A' }}</td>
                                <td class="px-3 py-2 text-right font-semibold">
                                    {{ number_format($product['current_stock'], 0, ',', ' ') }}
                                    <span class="text-xs text-gray-500">{{ Str::plural($product['unit'], $product['current_stock']) }}</span>
                                </td>
                                <td class="px-3 py-2 text-right">
                                    {{ number_format($product['purchase_price'], 0, ',', ' ') }}
                                    {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                                </td>
                                <td class="px-3 py-2 text-right font-semibold">
                                    {{ number_format($product['stock_value'], 0, ',', ' ') }}
                                    {{ \App\Models\Setting::DEFAULT_CURRENCY }}
                                </td>
                                <td class="px-3 py-2 text-center">
                                    @php
                                        $status = $product['stock_status'];
                                        $colorClasses = [
                                            'green' => 'bg-green-100 text-green-800 border-green-500',
                                            'orange' => 'bg-orange-100 text-orange-800 border-orange-500',
                                            'red' => 'bg-red-100 text-red-800 border-red-500',
                                        ];
                                        $colorClass = $colorClasses[$status['color']] ?? 'bg-gray-100 text-gray-800 border-gray-500';
                                    @endphp
                                    <span
                                        class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium border {{ $colorClass }}">
                                        <i class="ph ph-{{ $status['icon'] }} mr-1"></i>
                                        {{ $status['label'] }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-12 text-gray-500">
                <i class="ph ph-package text-5xl mb-3"></i>
                <p class="text-lg font-medium">Aucun produit trouvé</p>
                <p class="text-sm">Essayez de modifier vos filtres</p>
            </div>
        @endif
    </x-basics.card>
</div>

