<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rapport de Stock - {{ now()->format('d/m/Y') }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #333;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 3px solid #4F46E5;
        }

        .header h1 {
            font-size: 24pt;
            color: #4F46E5;
            margin-bottom: 5px;
        }

        .header p {
            color: #666;
            font-size: 10pt;
        }

        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
        }

        .summary-item {
            text-align: center;
        }

        .summary-item .label {
            font-size: 9pt;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .summary-item .value {
            font-size: 18pt;
            font-weight: bold;
            color: #4F46E5;
            margin-top: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        th {
            background-color: #4F46E5;
            color: white;
            font-weight: 600;
            font-size: 10pt;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        tr:hover {
            background-color: #f0f0f0;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .status {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 9pt;
            font-weight: 600;
        }

        .status-green {
            background-color: #D1FAE5;
            color: #065F46;
        }

        .status-orange {
            background-color: #FED7AA;
            color: #92400E;
        }

        .status-red {
            background-color: #FEE2E2;
            color: #991B1B;
        }

        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e0e0e0;
            text-align: center;
            font-size: 9pt;
            color: #666;
        }

        @media print {
            body {
                padding: 0;
            }

            .header {
                page-break-after: avoid;
            }

            table {
                page-break-inside: auto;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }
        }

        @page {
            margin: 15mm;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>📦 Rapport de Stock</h1>
        <p>Généré le {{ now()->format('d/m/Y à H:i') }}</p>
        @if ($stockStatus !== 'all')
            <p style="margin-top: 5px; font-style: italic;">
                Filtre appliqué: Statut -
                {{ $stockStatus === 'in_stock' ? 'En stock' : ($stockStatus === 'low_stock' ? 'Stock faible' : 'En rupture') }}
            </p>
        @endif
    </div>

    <div class="summary">
        <div class="summary-item">
            <div class="label">Total Produits</div>
            <div class="value">{{ number_format($totalProducts, 0, ',', ' ') }}</div>
        </div>
        <div class="summary-item">
            <div class="label">Quantité Totale</div>
            <div class="value">{{ number_format($totalStockQuantity, 0, ',', ' ') }}</div>
        </div>
        <div class="summary-item">
            <div class="label">Valeur Totale</div>
            <div class="value">{{ number_format($totalStockValue, 0, ',', ' ') }}
                {{ \App\Models\Setting::DEFAULT_CURRENCY }}</div>
        </div>
    </div>

    @if ($products->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Produit</th>
                    <th>SKU</th>
                    <th class="text-right">Stock</th>
                    <th class="text-right">Coût Unit.</th>
                    <th class="text-right">Valeur</th>
                    <th class="text-center">Statut</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($products as $product)
                    @php
                        $stockValue = $product->current_stock * ($product->purchase_price ?? 0);
                        if ($product->current_stock <= 0) {
                            $status = 'Rupture';
                            $statusClass = 'status-red';
                        } elseif ($product->current_stock <= $product->reorder_level) {
                            $status = 'Stock faible';
                            $statusClass = 'status-orange';
                        } else {
                            $status = 'En stock';
                            $statusClass = 'status-green';
                        }
                    @endphp
                    <tr>
                        <td>{{ $product->name }}</td>
                        <td>{{ $product->sku ?? 'N/A' }}</td>
                        <td class="text-right">
                            @php
                                $unit = $product->saleUnit?->abbreviation ?? $product->purchaseUnit?->abbreviation ?? 'N/A';
                            @endphp
                            <strong>{{ number_format($product->current_stock, 0, ',', ' ') }}</strong>
                            {{ $unit }}
                        </td>
                        <td class="text-right">{{ number_format($product->purchase_price ?? 0, 0, ',', ' ') }}
                            {{ \App\Models\Setting::DEFAULT_CURRENCY }}</td>
                        <td class="text-right"><strong>{{ number_format($stockValue, 0, ',', ' ') }}
                                {{ \App\Models\Setting::DEFAULT_CURRENCY }}</strong></td>
                        <td class="text-center">
                            <span class="status {{ $statusClass }}">{{ $status }}</span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <div style="text-align: center; padding: 60px 20px; color: #666;">
            <p style="font-size: 16pt; margin-bottom: 10px;">Aucun produit trouvé</p>
            <p style="font-size: 11pt;">Aucun produit ne correspond aux critères sélectionnés</p>
        </div>
    @endif

    <div class="footer">
        <p><strong>{{ \App\Models\Setting::first()->merchant_name ?? 'Ango' }}</strong></p>
        <p>Document généré automatiquement - Page 1</p>
    </div>

    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>

</html>

