<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Types de ventes' => route('sale-types.index'),
        $saleType->name => null,
    ]">
        <x-slot name="action">
            <x-dashboard.sale-types.dropdown :saleType="$saleType" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations du type de vente" subtitle="Détails du type de vente">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Sale Type Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-receipt text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom du type</h3>
                                <p class="text-sm text-gray-600">{{ $saleType->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Created Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Créé le</h3>
                                <p class="text-sm text-gray-600">{{ $saleType->created_at->format('d/m/Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if($saleType->description)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                <p class="text-sm text-gray-600">{{ $saleType->description }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.sale-types.sidebar :saleType="$saleType" />
        </div>
    </div>
</div>
