<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture - {{ $sale->sale_number }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
            .print-container { margin: 0; }
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="print-container max-w-4xl mx-auto bg-white p-8">
      

        <!-- Header -->
        <div class="border-b-2 border-gray-300 pb-6 mb-6">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">{{ \App\Models\Setting::merchantName() }}</h1>
                    <p class="text-gray-600">{{ \App\Models\Setting::merchantAddress() }}</p>
                    <p class="text-gray-600">Tél: {{ \App\Models\Setting::merchantPhone() }}</p>
                    <p class="text-gray-600">Email: {{ \App\Models\Setting::merchantEmail() }}</p>
                </div>
                <div class="text-right">
                    <h2 class="text-2xl font-bold text-blue-600">FACTURE</h2>
                    <p class="text-lg font-semibold">{{ $sale->sale_number }}</p>
                    <p class="text-gray-600">Date: {{ $sale->created_at->format('d/m/Y H:i') }}</p>
                </div>
            </div>
        </div>

        <!-- Customer Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div>
                <h3 class="font-semibold text-gray-900 mb-2">Facturé à:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    @if($sale->customer)
                        <p class="font-semibold">{{ $sale->customer->name }}</p>
                        @if($sale->customer->contact)
                            <p>{{ $sale->customer->contact->phone }}</p>
                            <p>{{ $sale->customer->contact->email }}</p>
                        @endif
                    @else
                        <p class="text-gray-600">Client anonyme</p>
                    @endif
                </div>
            </div>
            <div>
                <h3 class="font-semibold text-gray-900 mb-2">Informations de vente:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    <p><span class="font-semibold">Vendu par:</span> {{ $sale->soldBy->firstname }} {{ $sale->soldBy->lastname }}</p>
                    <p><span class="font-semibold">Méthode de paiement:</span> {{ $sale->payment_method->name ?? 'N/A' }}</p>
                    <p><span class="font-semibold">Type de vente:</span> {{ $sale->sale_type->name ?? 'N/A' }}</p>
                </div>
            </div>
        </div>

        <!-- Items Table -->
        <div class="mb-6">
            <h3 class="font-semibold text-gray-900 mb-4">Articles vendus:</h3>
            <table class="w-full border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-100">
                        <th class="border border-gray-300 px-4 py-2 text-left">Produit</th>
                        <th class="border border-gray-300 px-4 py-2 text-center">Quantité</th>
                        <th class="border border-gray-300 px-4 py-2 text-right">Prix unitaire</th>
                        <th class="border border-gray-300 px-4 py-2 text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sale->items as $item)
                        <tr>
                            <td class="border border-gray-300 px-4 py-2">
                                <div>
                                    <p class="font-semibold">{{ $item->product->name }}</p>
                                    <p class="text-sm text-gray-600">{{ $item->product->category->name ?? 'Sans catégorie' }}</p>
                                </div>
                            </td>
                            <td class="border border-gray-300 px-4 py-2 text-center">
                                {{ $item->quantity }} {{ Str::plural($item->product->saleUnit?->name ?? '', $item->quantity) }}
                            </td>
                            <td class="border border-gray-300 px-4 py-2 text-right">
                                {{ number_format($item->unit_price, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                            </td>
                            <td class="border border-gray-300 px-4 py-2 text-right font-semibold">
                                {{ number_format($item->total_price, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Totals -->
        <div class="flex justify-end mb-6">
            <div class="w-80">
                <div class="border border-gray-300">
                    <div class="flex justify-between px-4 py-2 border-b border-gray-300">
                        <span>Sous-total:</span>
                        <span>{{ number_format($sale->subtotal, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}</span>
                    </div>

                    @if($sale->tax_amount > 0)
                    <div class="flex justify-between px-4 py-2 border-b border-gray-300">
                        <span>Taxes:</span>
                        <span>{{ number_format($sale->tax_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}</span>
                    </div>
                    @endif

                    @if($sale->discount_amount > 0)
                    <div class="flex justify-between px-4 py-2 border-b border-gray-300">
                        <span>Remise:</span>
                        <span>-{{ number_format($sale->discount_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}</span>
                    </div>
                    @endif

                    <div class="flex justify-between px-4 py-2 bg-gray-100 font-bold text-lg">
                        <span>Total:</span>
                        <span>{{ number_format($sale->total_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Notes -->
        @if($sale->notes)
            <div class="mb-6">
                <h3 class="font-semibold text-gray-900 mb-2">Notes:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    <p>{{ $sale->notes }}</p>
                </div>
            </div>
        @endif

        <!-- Footer -->
        <div class="border-t-2 border-gray-300 pt-6 text-center text-gray-600">
            <p>Merci pour votre achat!</p>
            <p class="text-sm mt-2">Généré par <strong>Ango</strong> le {{ now()->format('d/m/Y à H:i') }}</p>
        </div>
    </div>

    <script>
        // Auto print when page loads (optional)
        window.onload = function() { window.print(); }
    </script>
</body>
</html>