<div class="container mx-auto">
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Ventes' => route('sales.index'),
        $sale->sale_number => null,
    ]">
        <x-slot name="action">
            <x-dashboard.sales.dropdown :sale="$sale" />
        </x-slot>
    </x-dashboard.breadcrumb>

        <div class="flex flex-col lg:flex-row gap-6 mt-6">
            <!-- Main Content -->
            <div class="w-full lg:w-8/12 space-y-6">
                <!-- Sale Details -->
                <x-basics.card title="Informations de la Vente" subtitle="Détails complets de la transaction">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Customer Info -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-user text-blue-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Client</h3>
                                    @if ($sale->customer)
                                        <x-basics.link href="{{ route('customers.show', $sale->customer) }}" variant="link"
                                            size="normal" class="text-sm text-gray-600">
                                            {{ $sale->customer->name }}
                                        </x-basics.link>
                                    @else
                                        <p class="text-sm text-gray-600">Client anonyme</p>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Salesperson Info -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-user-circle text-green-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Vendu par</h3>
                                    @if ($sale->soldBy)
                                        <x-basics.link href="{{ route('users.show', $sale->soldBy) }}" variant="link"
                                            size="normal" class="text-sm text-gray-600">
                                            {{ $sale->soldBy->firstname . ' ' . $sale->soldBy->lastname }}
                                        </x-basics.link>
                                    @else
                                        <p class="text-sm text-gray-600">Utilisateur</p>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-credit-card text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Méthode de paiement</h3>
                                    <p class="text-sm text-gray-600">{{ $sale->getPaymentMethodLabel() }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Sale Type -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-tag text-orange-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Type de vente</h3>
                                    <p class="text-sm text-gray-600">{{ $sale->getSaleTypeLabel() }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if ($sale->prescription)
                        <div class="mt-6 bg-blue-50 rounded-lg p-4">
                            <div class="flex items-center">
                                <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-file-text text-blue-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Prescription</h3>
                                    <p class="text-sm text-gray-600">{{ $sale->prescription?->prescription_number ?? 'Non défini' }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if ($sale->notes)
                        <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                            <div class="flex items-start">
                                <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                    <i class="ph ph-note text-yellow-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-2">Notes</h3>
                                    <p class="text-sm text-gray-600">{{ $sale->notes ?? 'Non défini' }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </x-basics.card>

                <!-- Sale Items -->
                @if ($sale->items->count() > 0)
                    <x-basics.card title="Articles Vendus" subtitle="Liste des produits vendus">
                        <div class="space-y-4">
                            @foreach ($sale->items as $item)
                                <div
                                    class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                                        <div class="flex items-center space-x-4 w-full sm:w-auto">
                                            <div
                                                class="w-12 h-12 bg-gradient-to-br from-blue-100 to-blue-200 rounded-lg flex items-center justify-center flex-shrink-0">
                                                <i class="ph ph-package text-blue-600 text-lg"></i>
                                            </div>
                                            <div class="min-w-0 flex-1">
                                                <h3 class="font-semibold text-gray-900 text-lg truncate">{{ $item->product->name }}
                                                </h3>
                                                <p class="text-sm text-gray-500">
                                                    {{ $item->product->category->name ?? 'Sans catégorie' }}</p>
                                            </div>
                                        </div>
                                        <div class="w-full sm:w-auto">
                                            <div class="grid grid-cols-3 gap-4 sm:flex sm:items-center sm:space-x-6">
                                                <div class="text-center">
                                                    <p class="text-xs sm:text-sm text-gray-500">Quantité</p>
                                                    <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                        {{ $item->quantity }}
                                                        <span class="hidden sm:inline">{{ Str::plural($item->product->saleUnit?->name) ?? '' }}</span>
                                                    </p>
                                                </div>
                                                <div class="text-center">
                                                    <p class="text-xs sm:text-sm text-gray-500">Prix unitaire</p>
                                                    <p class="font-semibold text-gray-900 text-sm sm:text-base">
                                                        {{ number_format($item->unit_price, 0, ',', ' ') }}
                                                        {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                                    </p>
                                                </div>
                                                <div class="text-center">
                                                    <p class="text-xs sm:text-sm text-gray-500">Total</p>
                                                    <p class="font-bold text-base sm:text-lg text-blue-600">
                                                        {{ number_format($item->total_price, 0, ',', ' ') }}
                                                        {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Summary -->
                        <div class="mt-6 pt-6 border-t border-gray-200">
                            <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
                                <div class="text-center sm:text-right">
                                    <p class="text-sm text-gray-500">Total des articles</p>
                                    <p class="text-2xl font-bold text-gray-900">{{ $sale->items->count() }}</p>
                                </div>
                                <div class="text-center sm:text-right">
                                    <p class="text-sm text-gray-500">Montant total</p>
                                    <p class="text-2xl sm:text-3xl font-bold text-blue-600">
                                        {{ number_format($sale->total_amount, 0, ',', ' ') }} {!! \App\Models\Setting::DEFAULT_CURRENCY !!}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </x-basics.card>
                @endif

            </div>

            <!-- Sidebar -->
            <div class="w-full lg:w-4/12 space-y-6">
                <x-dashboard.sales.sidebar :sale="$sale" />
            </div>
        </div>
    </div>
</div>
