<div class="container mx-auto" x-data>

    <x-dashboard.breadcrumb :items="[
            'Ajustements de stock' => route('stock-adjustments.index'),
            $adjustment->reference => route('stock-adjustments.show', $adjustment),
            'Modifier' => null,
        ]">
        <x-slot name="action">
            <x-dashboard.stock-adjustments.dropdown :adjustment="$adjustment" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">

            <!-- General Information Form -->
            <form wire:submit.prevent="saveGeneral">
                <x-basics.card title="Informations générales" subtitle="Paramètres de l'ajustement">

                    <x-slot name="action">
                        <x-basics.flash :model="'generalSuccess'" :timeout="3000" />
                    </x-slot>

                    <div class="space-y-4">
                        @if ($errors->has('general_error'))
                            <x-basics.alert type="danger" :message="$errors->first('general_error')" />
                        @endif

                        @php
                            $types = collect(\App\Models\StockAdjustment::TYPES)->map(function ($type) {
                                return (object) $type;
                            });
                        @endphp

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <x-basics.input label="Référence" name="reference" :value="$adjustment->reference" mb="mb-0"
                                :disabled="true" />

                            <x-basics.select name="type" wire:model.defer="type" label="Type" :options="$types"
                                optionValue="id" optionLabel="name" placeholder="Sélectionner" mb="mb-0"
                                :disabled="$disabled" />
                        </div>

                        <x-basics.input label="Raison" name="reason" wire:model.defer="reason"
                            placeholder="Ex. Expiré" :disabled="$disabled" />

                        <x-basics.textarea label="Notes" name="notes" wire:model.defer="notes" rows="2"
                            placeholder="Notes supplémentaires" mb="mb-0" :disabled="$disabled" />
                    </div>

                    @if (!$disabled)
                        <x-slot name="footer">
                            <x-basics.button type="submit" class="lg:w-1/2" :disabled="$generalLoading"
                                leftIcon="floppy-disk">
                                Enregistrer les modifications
                            </x-basics.button>
                        </x-slot>
                    @endif
                </x-basics.card>
            </form>

            <!-- Items List and Add Item -->
            <x-basics.card title="Articles de l'ajustement" subtitle="Gérez les articles affectés">
                <x-slot name="action">
                    <x-basics.flash :model="'itemsSuccess'" :timeout="3000" />
                </x-slot>

                @if ($adjustment->items->count() > 0)
                    <div class="overflow-x-auto mb-6">
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Quantité</th>
                                    @if ($adjustment->status === App\Models\StockAdjustment::STATUS_DRAFT)
                                        <th class="p-3 text-left font-medium text-gray-700"></th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($adjustment->items as $item)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2 font-medium">{{ $item->product->name ?? 'Produit supprimé' }}
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">{{ $item->quantity }}</td>
                                        @if ($adjustment->status === App\Models\StockAdjustment::STATUS_DRAFT)
                                            <td class="px-3 py-2 text-right">
                                                <x-basics.button variant="outline-red"
                                                    wire:click="deleteItem({{ $item->id }})" size="sm">
                                                    <i class="ph ph-bold ph-trash"></i>
                                                </x-basics.button>
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <i class="ph ph-package text-4xl mb-2"></i>
                        <p>Aucun article ajouté à cet ajustement.</p>
                        <p class="text-sm">Utilisez le formulaire ci-dessous pour commencer.</p>
                    </div>
                @endif

                @if ($adjustment->status === App\Models\StockAdjustment::STATUS_DRAFT)
                    <!-- Add Item Form -->
                    <form wire:submit.prevent="addItem">
                        @if ($errors->has('item_error'))
                            <x-basics.alert type="danger" :message="$errors->first('item_error')" class="mb-4" />
                        @endif

                        <div class="flex items-end gap-2 bg-gray-50 p-4 rounded-lg mt-6">
                            <div class="w-2/3">
                                <x-basics.input-select name="product_id" wire:model.live="product_id" label="Produit"
                                    :options="$products" optionValue="id" optionLabel="name"
                                    placeholder="Choisir un produit" orientation="top" required mb="mb-0" />
                            </div>

                            <div>
                                <x-basics.input type="number" name="quantity" wire:model.defer="quantity"
                                    label="Quantité" min="1" required />
                            </div>

                            <div class="flex justify-end">
                                <x-basics.button type="submit" :disabled="$addItemLoading" variant="primary">
                                    <i class="ph ph-plus"></i>
                                </x-basics.button>
                            </div>
                        </div>
                    </form>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <i class="ph ph-lock text-4xl mb-2"></i>
                        <p>Cet ajustement ne peut plus être modifié.</p>
                        <p class="text-sm">Seuls les brouillons peuvent être modifiés.</p>
                    </div>
                @endif
            </x-basics.card>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.stock-adjustments.sidebar :adjustment="$adjustment" />
        </div>
    </div>
</div>
