<div class="container mx-auto" x-data="{ showCreateAdjustmentModal: false }">

    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Ajustements de stock' => null,
    ]">
        <x-slot name="action">
            <x-basics.button @click="showCreateAdjustmentModal = true">
                <i class="ph ph-plus mr-2"></i>
                Nouvel ajustement
            </x-basics.button>
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="w-full min-h-screen mt-6">
        @php
            $types = collect(App\Models\StockAdjustment::TYPES)->map(function ($type) {
                return (object) $type;
            });
            $statuses = collect(App\Models\StockAdjustment::STATUSES)->map(function ($status) {
                return (object) $status;
            });
        @endphp

        <!-- Filters Section -->
        <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
            <form action="{{ route('stock-adjustments.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <x-basics.input name="search" label="Rechercher..." placeholder="Référence..."
                        value="{{ request('search') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="type" label="Type" placeholder="Tous" :options="$types" optionLabel="name" optionValue="id"
                        value="{{ request('type') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statuses" optionLabel="name" optionValue="id"
                        value="{{ request('status') }}" mb="0" />
                </div>

                <div class="flex gap-2">
                    <x-basics.button type="submit">
                        <i class="ph ph-magnifying-glass mr-2"></i>
                        Filtrer
                    </x-basics.button>
                    @if (request('search') || request('type') || request('status'))
                        <x-basics.button-link href="{{ route('stock-adjustments.index') }}" variant="outline">
                            <i class="ph ph-arrow-clockwise mr-2"></i>
                            Reset
                        </x-basics.button-link>
                    @endif
                </div>
            </form>
        </div>

        <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
            <div class="p-4 border-b">
                <h4 class="font-semibold text-gray-800">Liste des ajustements</h4>
            </div>
            <div class="overflow-x-auto">
                @if ($adjustments->count() > 0)
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                <th class="p-3 text-left font-medium text-gray-700">Référence</th>
                                <th class="p-3 text-left font-medium text-gray-700">Type</th>
                                <th class="p-3 text-left font-medium text-gray-700">Articles</th>
                                <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                <th class="p-3 text-left font-medium text-gray-700">Créé le</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($adjustments as $adjustment)
                                <tr class="border-t hover:bg-gray-50">
                                    <td class="px-3 py-2">
                                        {{ ($adjustments->currentPage() - 1) * $adjustments->perPage() + $loop->iteration }}.
                                    </td>
                                    <td class="px-3 py-2">
                                        <x-basics.link size="normal"
                                            href="{{ route('stock-adjustments.show', $adjustment) }}">{{ $adjustment->reference }}
                                        </x-basics.link>
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        {{ $adjustment->getTypeName() }}</td>
                                    <td class="px-3 py-2 text-gray-600">{{ $adjustment->items_count }}</td>
                                    <td class="px-3 py-2">{!! $adjustment->getStatusBadge() !!}</td>
                                    <td class="px-3 py-2 text-gray-600">{{ $adjustment->created_at->format('d/m/Y') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    @if ($adjustments->hasPages())
                        <div class="mt-6 px-4 pb-4">
                            {{ $adjustments->links() }}
                        </div>
                    @endif
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-arrows-left-right text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun ajustement trouvé</p>
                            <p class="text-sm">Créez un nouvel ajustement pour commencer</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Create Adjustment Modal -->
        <form action="{{ route('stock-adjustments.store') }}" method="POST">
            @csrf
            <x-basics.modal show="showCreateAdjustmentModal" title="Créer un ajustement"
                description="Configurez l'ajustement de stock">
                <x-basics.select name="type" label="Type" :options="$types" placeholder="Sélectionner un type"
                    required mb="mb-6" />
                <x-basics.input name="reason" label="Raison" placeholder="Ex. Expiré, cassé..." />

                @slot('footer')
                    <div class="flex justify-end">
                        <x-basics.button type="submit" class="w-full">
                            Créer l'ajustement
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
    </div>
</div>
