<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajustement de Stock - {{ $adjustment->reference }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
            .print-container { margin: 0; }
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="print-container max-w-4xl mx-auto bg-white p-8">
      
        <!-- Header -->
        <div class="border-b-2 border-gray-300 pb-6 mb-6">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">{{ \App\Models\Setting::merchantName() }}</h1>
                    <p class="text-gray-600">{{ \App\Models\Setting::merchantAddress() }}</p>
                    <p class="text-gray-600">Tél: {{ \App\Models\Setting::merchantPhone() }}</p>
                    <p class="text-gray-600">Email: {{ \App\Models\Setting::merchantEmail() }}</p>
                </div>
                <div class="text-right">
                    <h2 class="text-2xl font-bold text-blue-600">AJUSTEMENT DE STOCK</h2>
                    <p class="text-lg font-semibold">{{ $adjustment->reference }}</p>
                    <p class="text-gray-600">Date: {{ $adjustment->created_at->format('d/m/Y H:i') }}</p>
                </div>
            </div>
        </div>

        <!-- Adjustment Info -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div>
                <h3 class="font-semibold text-gray-900 mb-2">Informations d'ajustement:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    <p><span class="font-semibold">Type:</span> {{ $adjustment->type === 'increase' ? 'Augmentation' : 'Diminution' }}</p>
                    <p><span class="font-semibold">Référence:</span> {{ $adjustment->reference }}</p>
                    @if($adjustment->reason)
                        <p><span class="font-semibold">Raison:</span> {{ $adjustment->reason }}</p>
                    @endif
                </div>
            </div>
            <div>
                <h3 class="font-semibold text-gray-900 mb-2">Détails:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    <p><span class="font-semibold">Date:</span> {{ $adjustment->created_at->format('d/m/Y H:i') }}</p>
                    <p><span class="font-semibold">Nombre d'articles:</span> {{ $adjustment->items->count() }}</p>
                </div>
            </div>
        </div>

        <!-- Items Table -->
        <div class="mb-6">
            <h3 class="font-semibold text-gray-900 mb-4">Articles ajustés:</h3>
            <table class="w-full border-collapse border border-gray-300">
                <thead>
                    <tr class="bg-gray-100">
                        <th class="border border-gray-300 px-4 py-2 text-left">#</th>
                        <th class="border border-gray-300 px-4 py-2 text-left">Produit</th>
                        <th class="border border-gray-300 px-4 py-2 text-center">Quantité</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($adjustment->items as $index => $item)
                        <tr>
                            <td class="border border-gray-300 px-4 py-2">{{ $index + 1 }}</td>
                            <td class="border border-gray-300 px-4 py-2">
                                <div>
                                    <p class="font-semibold">{{ $item->product?->name ?? 'Produit non défini' }}</p>
                                    @if($item->product?->category)
                                        <p class="text-sm text-gray-600">{{ $item->product->category->name }}</p>
                                    @endif
                                </div>
                            </td>
                            <td class="border border-gray-300 px-4 py-2 text-center font-semibold">
                                {{ $adjustment->type === 'increase' ? '+' : '-' }}{{ $item->quantity }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Notes -->
        @if($adjustment->notes)
            <div class="mb-6">
                <h3 class="font-semibold text-gray-900 mb-2">Notes:</h3>
                <div class="bg-gray-50 p-4 rounded">
                    <p>{{ $adjustment->notes }}</p>
                </div>
            </div>
        @endif

        <!-- Footer -->
        <div class="border-t-2 border-gray-300 pt-6 text-center text-gray-600">
            <p class="text-sm mt-2">Généré par <strong>Ango</strong> le {{ now()->format('d/m/Y à H:i') }}</p>
        </div>
    </div>

    <script>
        // Auto print when page loads (optional)
        window.onload = function() { window.print(); }
    </script>
</body>
</html>
