<div class="container mx-auto" x-data="{ showCreateStockEntryModal: false }">

    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Entrées de stock' => null,
    ]">
    </x-dashboard.breadcrumb>

    <div class="w-full min-h-screen mt-6">

        @php
            $sourceTypes = collect([
                ['id' => App\Models\StockEntry::SOURCE_TYPE_PURCHASE, 'name' => 'Achat', 'slug' => 'purchase'],
                [
                    'id' => App\Models\StockEntry::SOURCE_TYPE_ADJUSTMENT,
                    'name' => 'Ajustement',
                    'slug' => 'adjustment',
                ],
                ['id' => App\Models\StockEntry::SOURCE_TYPE_TRANSFER, 'name' => 'Transfert', 'slug' => 'transfer'],
                ['id' => App\Models\StockEntry::SOURCE_TYPE_RETURN, 'name' => 'Retour', 'slug' => 'return'],
            ])->map(function ($status) {
                return (object) $status;
            });
        @endphp

        <!-- Filters Section -->
        <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
            <form action="{{ route('stock-entries.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <x-basics.input name="search" label="Rechercher..." placeholder="Nom du produit..."
                        value="{{ request('search') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="source_type" label="Type de source" placeholder="Tous" :options="$sourceTypes" optionLabel="name" optionValue="id"
                        value="{{ request('source_type') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.input name="date_from" label="Date de début" type="date"
                        value="{{ request('date_from') }}" mb="0" />
                </div>

                <div class="flex gap-2">
                    <x-basics.button type="submit">
                        <i class="ph ph-magnifying-glass mr-2"></i>
                        Filtrer
                    </x-basics.button>
                    @if (request('search') || request('source_type') || request('date_from'))
                        <x-basics.button-link href="{{ route('stock-entries.index') }}" variant="outline">
                            <i class="ph ph-arrow-clockwise mr-2"></i>
                            Reset
                        </x-basics.button-link>
                    @endif
                </div>
            </form>
        </div>

        <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm">
            <div class="overflow-x-auto">

                @if ($stockEntries->count() > 0)
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                <th class="p-3 text-left font-medium text-gray-700">Référence</th>
                                <th class="p-3 text-left font-medium text-gray-700">Produit</th>
                                <th class="p-3 text-left font-medium text-gray-700">Type</th>
                                <th class="p-3 text-left font-medium text-gray-700">Fournisseur</th>
                                <th class="p-3 text-left font-medium text-gray-700">Quantité</th>
                                <th class="p-3 text-left font-medium text-gray-700">Date de création</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stockEntries as $stockEntry)
                                <tr class="border-t hover:bg-gray-50">
                                    <td class="px-3 py-2 font-medium">{{ $loop->iteration }}.</td>
                                    <td class="px-3 py-2">
                                        <x-basics.link size="normal"
                                            href="{{ route('stock-entries.show', $stockEntry) }}">
                                            {{ $stockEntry->reference }}
                                        </x-basics.link>
                                    </td>
                                    <td class="px-3 py-2 text-gray-900 font-medium">
                                        {{ $stockEntry->product->name ?? 'Produit supprimé' }}
                                    </td>
                                    <td class="px-3 py-2">
                                        {!! $stockEntry->getSourceTypeBadge() !!}
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        {{ $stockEntry->supplier?->name ?? '—' }}
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        {{ number_format($stockEntry->quantity) }}
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        {{ $stockEntry->created_at->format('d/m/Y H:i') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune entrée de stock trouvée</p>
                            <p class="text-sm">Commencez par enregistrer votre première entrée de stock</p>
                        </div>
                    </div>
                @endif

            </div>
        </div>

        <!-- Pagination -->
        @if ($stockEntries->hasPages())
            <div class="mt-6">
                {{ $stockEntries->links() }}
            </div>
        @endif
    </div>
</div>
