<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Abonnements' => route('subscriptions.index'),
        $subscription->code => null,
    ]">
    </x-dashboard.breadcrumb>

    <div class="mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Abonnement" subtitle="Détails de l'abonnement">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Subscription Code -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-hash text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Code d'abonnement</h3>
                                <p class="text-sm text-gray-600">{{ $subscription->code }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Category -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-tag text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Catégorie</h3>
                                <p class="text-sm text-gray-600">{{ $subscription->category ?? 'Non définie' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-info text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Statut</h3>
                                <div class="text-sm">{!! $subscription->status_badge !!}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Duration -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-clock text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Durée</h3>
                                <p class="text-sm text-gray-600">{{ $subscription->duration_in_days ?? 0 }} jours</p>
                            </div>
                        </div>
                    </div>

                    <!-- Activation Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar-plus text-cyan-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Date d'activation</h3>
                                <p class="text-sm text-gray-600">{{ optional($subscription->activated_at)->format('d/m/Y') ?? 'Non activé' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- End Date -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar-x text-red-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Date de fin</h3>
                                <p class="text-sm text-gray-600">{{ optional($subscription->end_date)->format('d/m/Y') ?? 'Non définie' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </x-basics.card>
        </div>

        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.subscriptions.sidebar :subscription="$subscription" />
        </div>
    </div>
</div>


