<div class="container mx-auto">
    <!-- Breadcrumb -->
    <x-dashboard.breadcrumb :items="[
        'Fournisseurs' => route('suppliers.index'),
        $supplier->name => route('suppliers.show', $supplier),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.suppliers.dropdown :supplier="$supplier" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="flex gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <!-- Edit Forms -->
            <div class="flex flex-col gap-6">
                <!-- General Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveGeneral">
                        <x-basics.card title="Informations générales">
                            <x-slot name="action">
                                <x-basics.flash :model="'successGeneral'" :timeout="3000" />
                            </x-slot>

                            <div class="space-y-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                    <x-basics.input label="Nom du fournisseur" required wire:model.defer="name"
                                        name="name" placeholder="Ex. PharmaCorp" mb="mb-0" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />

                                    <x-basics.input label="Personne de contact" wire:model.defer="contact_person"
                                        name="contact_person" required placeholder="Ex. Jean Dupont" mb="mb-0"
                                        :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />
                                </div>

                                <x-basics.textarea label="Notes" wire:model.defer="notes" name="notes"
                                    placeholder="Notes optionnelles..." mb="mb-0" rows="2"
                                    :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />
                            </div>

                            @if ($supplier->status == \App\Models\Supplier::STATUS_INACTIVE)
                                <x-slot name="footer">
                                    <x-basics.button type="submit" class="w-full" :disabled="$loading"
                                        leftIcon="floppy-disk">
                                        Enregistrer
                                    </x-basics.button>
                                </x-slot>
                            @endif
                        </x-basics.card>
                    </form>
                </div>

                <!-- Contact Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveContact">
                        <x-basics.card title="Informations de contact">
                            <x-slot name="action">
                                <x-basics.flash :model="'successContact'" :timeout="3000" />
                            </x-slot>

                            <div class="space-y-4">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <x-basics.input label="Numéro de téléphone" wire:model.defer="phone" name="phone"
                                        required placeholder="+243 999 999 999" mb="mb-0" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />

                                    <x-basics.input label="Email" type="email" wire:model.defer="email"
                                        name="email" placeholder="john.doe@example.com" mb="mb-0"
                                        :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <x-basics.input label="WhatsApp" wire:model.defer="whatsapp" name="whatsapp"
                                        placeholder="https://wa.me/yourprofile" mb="mb-0" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />

                                    <x-basics.input label="Site Web" wire:model.defer="website" name="website"
                                        placeholder="https://yourwebsite.com" mb="mb-0" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" />
                                </div>
                            </div>

                            @if ($supplier->status == \App\Models\Supplier::STATUS_INACTIVE)
                                <x-slot name="footer">
                                    <x-basics.button type="submit" class="w-full" :disabled="$loading"
                                        leftIcon="floppy-disk">
                                        Enregistrer
                                    </x-basics.button>
                                </x-slot>
                            @endif
                        </x-basics.card>
                    </form>
                </div>

                <!-- Location Information -->
                <div class="flex-1">
                    <form wire:submit.prevent="saveLocation">
                        <x-basics.card title="Localisation">
                            <x-slot name="action">
                                <x-basics.flash :model="'successLocation'" :timeout="3000" />
                            </x-slot>

                            <div>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">

                                    <x-basics.select name="province_id" wire:model.live="province_id" label="Province"
                                        :options="$provinces" optionValue="id" optionLabel="name"
                                        placeholder="Sélectionner une province"
                                        error="{{ $errors->first('province_id') }}" :required="true"
                                        :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" class="mb-4" />

                                    <x-basics.select name="city_id" wire:model.live="city_id" label="Ville"
                                        :options="$cities" optionValue="id" optionLabel="name"
                                        placeholder="Sélectionner une ville" error="{{ $errors->first('city_id') }}"
                                        :required="true" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" class="mb-4" />

                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
                                    <x-basics.input name="commune" wire:model="commune" label="Commune"
                                        placeholder="Ex. Kalamu" :required="false" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" class="mb-4" />

                                    <x-basics.input name="quarter" label="Quartier" wire:model="quarter"
                                        placeholder="Ex. Front" :required="false" :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" class="mb-4" />
                                </div>
                                <div class="grid grid-cols-1 gap-2">
                                    <x-basics.input wire:model="description" name="description" label="Description"
                                        placeholder="Ex. Av. de la République, No. 123" :required="false"
                                        :disabled="$supplier->status == \App\Models\Supplier::STATUS_ACTIVE" class="mb-0" />
                                </div>
                            </div>

                            @if ($supplier->status == \App\Models\Supplier::STATUS_INACTIVE)
                                <x-slot name="footer">
                                    <x-basics.button type="submit" class="w-full" :disabled="$loading"
                                        leftIcon="floppy-disk">
                                        Enregistrer
                                    </x-basics.button>
                                </x-slot>
                            @endif
                        </x-basics.card>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.suppliers.sidebar :supplier="$supplier" />
        </div>
    </div>
</div>
