<div class="container mx-auto" x-data="{ showCreateSupplierModal: false }">
        @php
            $statuses = collect([
                ['id' => 1, 'name' => 'Actif'],
                ['id' => 0, 'name' => 'Inactif'],
            ])->map(function ($status) {
                return (object) $status;
            });
        @endphp
        
        <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Fournisseurs' => null,
        ]">
            <x-slot name="action">
                <x-basics.button @click="showCreateSupplierModal = true">
                    <i class="ph ph-plus mr-2"></i>
                    Ajouter un fournisseur
                </x-basics.button>
            </x-slot>
        </x-dashboard.breadcrumb>

        <!-- Search Section -->
        <div class="shadow border border-gray-300 bg-white rounded p-4 mb-6 mt-6">
            <form action="{{ route('suppliers.index') }}" method="GET"
                class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <x-basics.input name="search" label="Rechercher..." placeholder="Nom du fournisseur..."
                        value="{{ request('search') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="province" label="Province" placeholder="Tous" :options="$provinces"
                        value="{{ request('province') }}" mb="0" />
                </div>

                <div class="flex-1">
                    <x-basics.select name="status" label="Statut" placeholder="Tous" :options="$statuses"
                        value="{{ request('status') }}" mb="0" />
                </div>

                <div class="flex gap-2">
                    <x-basics.button type="submit">
                        <i class="ph ph-magnifying-glass mr-2"></i>
                        Rechercher
                    </x-basics.button>
                    @if (request('search') || request('province') || request('status'))
                    <x-basics.button-link href="{{ route('suppliers.index') }}" variant="outline">
                        <i class="ph ph-arrow-clockwise mr-2"></i>
                        Reset
                    </x-basics.button-link>
                    @endif
                </div>
            </form>
        </div>

        <!-- Suppliers Table -->
        <div class="bg-white border border-gray-300 rounded overflow-hidden shadow">
            <div class="p-4 border-b">
                <h4 class="font-semibold text-gray-800">Liste des fournisseurs</h4>
            </div>
            <div class="overflow-x-auto">
                @if($suppliers->count() > 0)
                    <table class="min-w-full text-sm">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                <th class="p-3 text-left font-medium text-gray-700">Fournisseur</th>
                                <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                <th class="p-3 text-left font-medium text-gray-700">Province</th>
                                <th class="p-3 text-left font-medium text-gray-700">Création</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($suppliers as $supplier)
                                <tr class="border-t hover:bg-gray-50">
                                    <td class="px-3 py-2">
                                        {{ $loop->iteration }}.
                                    </td>
                                    <td class="px-3 py-2">
                                        <x-basics.link size="normal" href="{{ route('suppliers.show', $supplier) }}">{{ $supplier->name ?? '—' }}</x-basics.link>
                                    </td>
                                    <td class="px-3 py-2">
                                        {!! $supplier->getStatusBadge() !!}
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        {{ $supplier->address?->province?->name ?? '—' }}
                                    </td>
                                    <td class="px-3 py-2 text-gray-600">
                                        @if ($supplier && $supplier->created_at)
                                            {{ Carbon\Carbon::parse($supplier->created_at)->format('d-m-Y') }}
                                        @else
                                            —
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-buildings text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucun fournisseur trouvé</p>
                            <p class="text-sm">Commencez par créer votre premier fournisseur</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Pagination -->
        @if ($suppliers->hasPages())
            <div class="mt-6">
                {{ $suppliers->links() }}
            </div>
        @endif

        <!-- Create Supplier Modal -->
        <form action="{{ route('suppliers.store') }}" method="POST">
            @csrf
            <x-basics.modal show="showCreateSupplierModal" title="Créer un fournisseur"
                description="Configurez votre fournisseur">

                <x-basics.input name="name" label="Nom du fournisseur" placeholder="Ex. PharmaCorp"
                    required mb="0" />

                @slot('footer')
                    <div class="flex justify-end">
                        <x-basics.button type="submit" class="w-full">
                            Créer le fournisseur
                        </x-basics.button>
                    </div>
                @endslot
            </x-basics.modal>
        </form>
</div> 