<div>
    <x-dashboard.breadcrumb :items="[
            'Dashboard' => route('home'),
            'Fournisseurs' => route('suppliers.index'),
            $supplier->name => null,
        ]">
            <x-slot name="action">
                <x-dashboard.suppliers.dropdown :supplier="$supplier" />
            </x-slot>
        </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations du Fournisseur" subtitle="Détails complets du fournisseur">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Supplier Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-buildings text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom du fournisseur</h3>
                                <p class="text-sm text-gray-600">{{ $supplier->name }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Person -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Personne de contact</h3>
                                <p class="text-sm text-gray-600">{{ $supplier->contact_person ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Phone -->
                    @if ($supplier->phone)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-phone text-purple-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Téléphone</h3>
                                    <p class="text-sm text-gray-600">{{ $supplier->phone }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Email -->
                    @if ($supplier->email)
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-envelope text-orange-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Email</h3>
                                    <p class="text-sm text-gray-600">{{ $supplier->email }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Address -->
                    @if ($supplier->address)
                        <div class="bg-gray-50 rounded-lg p-4 md:col-span-2">
                            <div class="flex items-center mb-3">
                                <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="ph ph-map-pin text-cyan-600"></i>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900">Adresse</h3>
                                    <p class="text-sm text-gray-600">
                                        {{ $supplier->address?->province?->name }} · {{ $supplier->address?->city?->name }}
                                    </p>
                                    <p class="text-sm text-gray-600">
                                        {{ $supplier->address?->description }}, {{ $supplier->address?->quarter }}, {{ $supplier->address?->commune }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>

                @if ($supplier->description)
                    <div class="mt-6 bg-yellow-50 rounded-lg p-4">
                        <div class="flex items-start">
                            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mr-3 mt-1">
                                <i class="ph ph-note text-yellow-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Description</h3>
                                <p class="text-sm text-gray-600">{{ $supplier->description }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </x-basics.card>

            <!-- Recent Purchase Orders -->
            <x-basics.card title="Commandes Récentes" subtitle="Dernières commandes de ce fournisseur">
                @if ($supplier->purchaseOrders->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th class="p-3 text-left font-medium text-gray-700 w-10">#</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Référence</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Statut</th>
                                    <th class="p-3 text-left font-medium text-gray-700">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($supplier->purchaseOrders->sortByDesc('order_date')->take(5) as $order)
                                    <tr class="border-t hover:bg-gray-50">
                                        <td class="px-3 py-2">{{ $loop->iteration }}.</td>
                                        <td class="px-3 py-2">
                                            <x-basics.link size="normal"
                                                href="{{ route('purchase-orders.show', $order) }}">{{ $order->reference }}</x-basics.link>
                                        </td>
                                        <td class="px-3 py-2">
                                            {!! $order->getStatusBadge() ?? '' !!}
                                        </td>
                                        <td class="px-3 py-2 text-gray-600">
                                            {{ $order->order_date?->format('d/m/Y') ?? '—' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if ($supplier->purchaseOrders->count() > 5)
                        <div class="mt-6">
                            <x-basics.button-link
                                href="{{ route('purchase-orders.index') }}?supplier_id={{ $supplier->id }}"
                                variant="outline">
                                Voir toutes les commandes
                            </x-basics.button-link>
                        </div>
                    @endif
                @else
                    <div class="text-center py-8">
                        <div class="text-gray-500">
                            <i class="ph ph-package text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune commande trouvée</p>
                            <p class="text-sm">Les commandes de ce fournisseur apparaîtront ici</p>
                        </div>
                    </div>
                @endif
            </x-basics.card>

        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.suppliers.sidebar :supplier="$supplier" />
        </div>
    </div>
</div>
