<div class="container mx-auto space-y-6">
    <x-dashboard.breadcrumb :items="[
        'Unités de mesure' => route('units.index'),
        $unit->name => route('units.show', $unit),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.units.dropdown :unit="$unit" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="container mx-auto flex flex-col lg:flex-row gap-6 mt-6">

        <!-- Main Content -->
        <div class="w-full lg:w-8/12 space-y-6">

            <!-- Edit Form -->
            <form wire:submit.prevent="save" method="POST" class="space-y-4">
                @csrf
                @method('PUT')
                <x-basics.card title="Modifier l'unité" subtitle="Modifiez les informations de l'unité de mesure">
                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :timeout="3000" />
                    </x-slot>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <x-basics.input name="name" label="Nom de l'unité" wire:model="name" class="mb-4"
                            placeholder="Ex. Comprimé" :error="$errors->first('name')" required />

                        <x-basics.input name="symbol" label="Symbole" wire:model="symbol" class="mb-4"
                            placeholder="Ex. cp" :error="$errors->first('symbol')" required />
                    </div>

                    <div class="mb-4">
                        <x-basics.textarea name="description" label="Description"
                            placeholder="Description de l'unité (optionnel)" :error="$errors->first('description')" rows="3"
                            wire:model="description"></x-basics.textarea>
                    </div>

                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="$loading" wire:loading.attr="disabled" wire:target="save" leftIcon="floppy-disk">
                            <span wire:loading.remove wire:target="save">Enregistrer les modifications</span>
                            <span wire:loading wire:target="save">Enregistrer...</span>
                        </x-basics.button>
                    </x-slot>
                    
                </x-basics.card>
            </form>
        </div>

        <!-- Sidebar -->
        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.units.sidebar :unit="$unit" />
        </div>
    </div>
</div>
