<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Utilisateurs' => route('users.index'),
        $user->username => route('users.show', $user),
        'Activités' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.account.dropdown :user="auth()->user()" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="mt-6">
        <div class="bg-white border border-gray-300 rounded overflow-hidden shadow-sm mb-8">
            <div class="p-4 border-b">
                <h4 class="font-semibold text-gray-800">Activités de {{ $user->firstname }} {{ $user->lastname }}</h4>
                <p class="text-sm text-gray-500">Les 25 dernières par page</p>
            </div>
            <div class="px-4 py-2">
                @if ($activities->count() > 0)
                    <div class="divide-y">
                        @foreach ($activities as $activity)
                            <div class="py-3 flex items-start justify-between">
                                <div class="text-sm text-gray-700">
                                    <div class="font-medium text-gray-900">{{ $activity->action ?? 'Activité' }}</div>
                                    <div class="text-gray-600">{{ $activity->description ?? '' }}</div>
                                </div>
                                <div class="text-xs text-gray-500 whitespace-nowrap">
                                    {{ $activity->created_at->format('d/m/Y H:i') }}
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @if ($activities->hasPages())
                        <div class="p-4 border-t bg-gray-50">
                            {{ $activities->onEachSide(1)->links() }}
                        </div>
                    @endif
                @else
                    <div class="text-center py-12">
                        <div class="text-gray-500">
                            <i class="ph ph-activity text-4xl mb-4"></i>
                            <p class="text-lg font-medium">Aucune activité trouvée</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>


