<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Utilisateurs' => route('users.index'),
        'Modifier' => null,
    ]">
        <x-slot name="action">
            <x-dashboard.users.dropdown :user="$user" />
        </x-slot>
    </x-dashboard.breadcrumb>

    <div class="mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <div class="w-full lg:w-8/12 space-y-6">
            <form wire:submit.prevent="save" class="space-y-4">
                <x-basics.card title="Modifier l'utilisateur" subtitle="Mettre à jour les informations">

                    <x-slot name="action">
                        <x-basics.flash :model="'success'" :message="$successMessage" :timeout="3000" />
                        <x-basics.flash :model="'error'" :message="$errorMessage" :timeout="3000" />
                    </x-slot>


                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="mb-4">
                            <x-basics.input name="firstname" label="Prénom" wire:model.live.debounce.1000ms="firstname" required :error="$errors->first('firstname')" />
                        </div>
                        <div class="mb-4">
                            <x-basics.input name="lastname" label="Nom" wire:model.live.debounce.1000ms="lastname" required :error="$errors->first('lastname')" />
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="mb-4">
                            <x-basics.input name="email" label="Email" wire:model.live.debounce.1000ms="email" required :error="$errors->first('email')" :disabled="true" :readonly="$user->isOwner()" />
                        </div>
                        <div class="mb-4">
                            <x-basics.input name="phone" label="Téléphone" wire:model.live.debounce.1000ms="phone" :error="$errors->first('phone')" />
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @php
                            $raw = App\Models\User::ROLES;
                            $items = is_string($raw) ? (json_decode($raw, true) ?: []) : (array) $raw;

                            $roles = collect($items)
                                ->map(function ($role) {
                                    // Normalize each item to an object with id/name
                                    if (is_string($role)) {
                                        return (object) ['id' => $role, 'name' => ucfirst($role)];
                                    }
                                    if (is_array($role)) {
                                        return (object) [
                                            'id' => $role['id'] ?? ($role['slug'] ?? null),
                                            'name' => $role['name'] ?? ($role['label'] ?? null),
                                        ];
                                    }
                                    return null;
                                })
                                ->filter(fn($r) => $r && $r->id && $r->name && $r->id !== 'owner')
                                ->values();
                        @endphp

                        <div class="mb-4">
                            <x-basics.select name="role" label="Rôle" placeholder="Sélectionnez le rôle" required :options="$roles" wire:model.live="role" :error="$errors->first('role')" />
                        </div>
                    </div>

                    <x-slot name="footer">
                        <x-basics.button type="submit" class="w-full" :disabled="!$can_save || $loading" leftIcon="floppy-disk" wire:target="save">
                            @if($loading)
                                Enregistrement...
                            @else
                                Enregistrer les modifications
                            @endif
                        </x-basics.button>
                    </x-slot>
                </x-basics.card>
            </form>
        </div>

        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.account.sidebar :user="$user" />
        </div>
    </div>
</div>
