<div>
    <x-dashboard.breadcrumb :items="[
        'Dashboard' => route('home'),
        'Utilisateurs' => route('users.index'),
        $user->full_name => null,
    ]">
        @if (!$user->isOwner() && Auth::user()->id !== $user->id)
            <x-slot name="action">
                <x-dashboard.users.dropdown :user="$user" />
            </x-slot>
        @endif
    </x-dashboard.breadcrumb>

    <div class="mx-auto flex flex-col lg:flex-row gap-6 mt-6">
        <div class="w-full lg:w-8/12 space-y-6">
            <x-basics.card title="Informations de l'utilisateur" subtitle="Détails">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Full Name -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-user text-blue-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom complet</h3>
                                <p class="text-sm text-gray-600">{{ $user->firstname }} {{ $user->lastname }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Username -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-at text-green-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Nom d'utilisateur</h3>
                                <p class="text-sm text-gray-600">{{ $user->username }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-at text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Email</h3>
                                <p class="text-sm text-gray-600">{{ $user->email ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Phone -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-phone text-purple-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Téléphone</h3>
                                <p class="text-sm text-gray-600">{{ $user->phone ?? 'Non défini' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Role -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-shield text-orange-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Rôle</h3>
                                <div class="text-sm">{{ $user->role_name }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Member Since -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center mb-3">
                            <div class="w-10 h-10 bg-emerald-100 rounded-lg flex items-center justify-center mr-3">
                                <i class="ph ph-calendar text-emerald-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900">Membre depuis</h3>
                                <p class="text-sm text-gray-600">{{ $user->created_at->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </x-basics.card>
        </div>

        <div class="w-full lg:w-4/12 space-y-6">
            <x-dashboard.users.sidebar :user="$user" />
        </div>
    </div>
</div>
