<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'show' => 'modalOpen',   // Alpine.js property
    'title' => '',           // Modal title
    'description' => '',     // Optional description
    'size' => 'md',          // sm, md, lg, xl, 2xl
    'canClose' => true,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'show' => 'modalOpen',   // Alpine.js property
    'title' => '',           // Modal title
    'description' => '',     // Optional description
    'size' => 'md',          // sm, md, lg, xl, 2xl
    'canClose' => true,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
$widthClasses = [
    'sm' => 'max-w-sm',
    'md' => 'max-w-md',
    'lg' => 'max-w-lg',
    'xl' => 'max-w-xl', 
    '2xl' => 'max-w-2xl',
];
$modalWidth = $widthClasses[$size] ?? $widthClasses['md'];
?>

<div
    x-show="<?php echo e($show); ?>"
    x-transition
    <?php if($canClose): ?>
        @click.self="<?php echo e($show); ?> = false"
    <?php endif; ?>
    class="fixed inset-0 z-50 flex items-center justify-center bg-black/40 backdrop-blur-sm"
    x-cloak
>
    <div
        x-transition
        class="w-full <?php echo e($modalWidth); ?> max-h-[90vh] bg-white rounded-lg shadow-lg overflow-y-auto"
    >
        <div class="px-6 py-6 border-b border-gray-200 flex justify-between items-start">
            <div>
                <!--[if BLOCK]><![endif]--><?php if($title): ?>
                    <h2 class="text-2xl font-bold text-gray-800"><?php echo e($title); ?></h2>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <!--[if BLOCK]><![endif]--><?php if($description): ?>
                    <p class="text-sm text-gray-600 mt-1"><?php echo e($description); ?></p>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <!--[if BLOCK]><![endif]--><?php if($canClose): ?>
                <button type="button" @click="<?php echo e($show); ?> = false" class="text-gray-400 hover:text-gray-600 transition-colors">
                    <i class="ph ph-x text-xl"></i>
                </button>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        <div class="px-6 py-8">
            <?php echo e($slot); ?>

        </div>

        
        <!--[if BLOCK]><![endif]--><?php if(isset($footer)): ?>
            <div class="px-6 py-4 border-t border-gray-200">
                <?php echo e($footer); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div>
<?php /**PATH D:\WORK\MAARIFA\ANGO\DESKTOP\V4\ango-desktop\resources\views/components/basics/modal.blade.php ENDPATH**/ ?>