<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name',
    'id' => null,
    'label' => null,
    'options' => [],
    'placeholder' => 'Select an option',
    'value' => null,
    'required' => false,
    'disabled' => false,
    'error' => null,
    'help' => null,
    'class' => '',
    'selectClass' => '',
    'labelClass' => '',
    'errorClass' => '',
    'helpClass' => '',
    'mb' => '',
    'optionValue' => 'id',
    'optionLabel' => 'name',
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name',
    'id' => null,
    'label' => null,
    'options' => [],
    'placeholder' => 'Select an option',
    'value' => null,
    'required' => false,
    'disabled' => false,
    'error' => null,
    'help' => null,
    'class' => '',
    'selectClass' => '',
    'labelClass' => '',
    'errorClass' => '',
    'helpClass' => '',
    'mb' => '',
    'optionValue' => 'id',
    'optionLabel' => 'name',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $id = $id ?? $name;
    $current = $value ?? old($name);
    
    // Base select classes with standardized height (44px) - consistent ring thickness
    $baseSelectClasses = 'block w-full h-11 rounded-lg border-0 py-2.5 px-4 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 placeholder:text-sm focus:ring-1 focus:ring-inset focus:ring-indigo-600 transition-all duration-200';
    
    // Add error state classes - same ring thickness
    if ($error) {
        $baseSelectClasses .= ' ring-red-500 focus:ring-red-500';
    }
    
    // Add disabled state classes
    if ($disabled) {
        $baseSelectClasses .= ' bg-gray-100 text-gray-500 cursor-not-allowed opacity-60 ring-gray-200';
        $baseSelectClasses = str_replace(' focus:ring-1 focus:ring-inset focus:ring-indigo-600', '', $baseSelectClasses);
    }
    
    // Add custom select classes
    $selectClasses = $baseSelectClasses . ' ' . $selectClass;
    
    // Base label classes - matching input component
    $baseLabelClasses = 'block text-sm font-medium leading-6 text-gray-900';
    
    // Add disabled label styling
    if ($disabled) {
        $baseLabelClasses .= ' text-gray-500';
    }
    
    $labelClasses = $baseLabelClasses . ' ' . $labelClass;
    
    // Base error classes - matching input component
    $baseErrorClasses = 'mt-1 text-sm text-red-600';
    $errorClasses = $baseErrorClasses . ' ' . $errorClass;
    
    // Base help classes - matching input component
    $baseHelpClasses = 'mt-1 text-sm text-gray-500';
    $helpClasses = $baseHelpClasses . ' ' . $helpClass;

    // Helper to read values from array or object
    $read = function ($item, $key) {
        if (is_array($item)) {
            return $item[$key] ?? null;
        }
        if (is_object($item)) {
            return $item->{$key} ?? null;
        }
        return null;
    };
?>

<div class="space-y-2 <?php echo e($class); ?> <?php echo e($mb); ?>">
    <!--[if BLOCK]><![endif]--><?php if($label): ?>
        <label for="<?php echo e($id); ?>" class="<?php echo e($labelClasses); ?>">
            <?php echo e($label); ?>

            <!--[if BLOCK]><![endif]--><?php if($required): ?>
                <span class="text-red-500">*</span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </label>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    
    <select 
        name="<?php echo e($name); ?>" 
        id="<?php echo e($id); ?>" 
        <?php if($required): ?> required <?php endif; ?>
        <?php if($disabled): ?> disabled <?php endif; ?>
        <?php echo e($attributes->merge(['class' => $selectClasses])); ?>

    >
        <option value=""><?php echo e($placeholder); ?></option>
        
        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $ov = $read($option, $optionValue);
                $ol = $read($option, $optionLabel);
            ?>
            <option value="<?php echo e($ov); ?>" <?php if($current == $ov): echo 'selected'; endif; ?>>
                <?php echo e($ol); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </select>
    
    <!--[if BLOCK]><![endif]--><?php if($error): ?>
        <div class="<?php echo e($errorClasses); ?>">
            <?php echo e($error); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    
    <!--[if BLOCK]><![endif]--><?php if($help): ?>
        <div class="<?php echo e($helpClasses); ?>">
            <?php echo e($help); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH D:\WORK\MAARIFA\ANGO\DESKTOP\V4\ango-desktop\resources\views/components/basics/select.blade.php ENDPATH**/ ?>