<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'md', // xs, sm, md, lg, xl
    'disabled' => false,
    'loading' => false,
    'loadingText' => null,
    'leftIcon' => null,
    'rightIcon' => null,
    'icon' => null,
    'iconPosition' => 'left',
    'class' => '',
    'badge' => null,
    'badgeColor' => 'red',
    'wireTarget' => null,  // For Livewire loading states
    'jsLoading' => false,  // For JavaScript loading states
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'type' => 'button',
    'variant' => 'primary',
    'size' => 'md', // xs, sm, md, lg, xl
    'disabled' => false,
    'loading' => false,
    'loadingText' => null,
    'leftIcon' => null,
    'rightIcon' => null,
    'icon' => null,
    'iconPosition' => 'left',
    'class' => '',
    'badge' => null,
    'badgeColor' => 'red',
    'wireTarget' => null,  // For Livewire loading states
    'jsLoading' => false,  // For JavaScript loading states
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    // Base button classes - consistent with input/select components
    $baseClasses = 'inline-flex items-center justify-center font-semibold rounded-lg shadow-sm transition-all duration-200 focus:ring-2 focus:ring-inset disabled:opacity-60 disabled:cursor-not-allowed disabled:bg-gray-200 disabled:text-gray-500 cursor-pointer';
    
    // Variant classes with matching focus colors
    $variantClasses = match($variant) {
        'primary' => 'bg-indigo-600 text-white hover:bg-indigo-500 focus:ring-indigo-600',
        'secondary' => 'bg-gray-600 text-white hover:bg-gray-500 focus:ring-gray-600',
        'success' => 'bg-green-600 text-white hover:bg-green-500 focus:ring-green-600',
        'danger' => 'bg-red-600 text-white hover:bg-red-500 focus:ring-red-600',
        'warning' => 'bg-yellow-600 text-white hover:bg-yellow-500 focus:ring-yellow-600',
        'info' => 'bg-blue-600 text-white hover:bg-blue-500 focus:ring-blue-600',
        'outline' => 'bg-transparent text-indigo-600 ring-1 ring-inset ring-indigo-600 hover:bg-indigo-50 focus:ring-indigo-600',
        'outline-red' => 'bg-transparent text-red-600 ring-1 ring-inset ring-red-600 hover:bg-red-50 focus:ring-red-600',
        'ghost' => 'bg-transparent text-gray-700 ring-1 ring-inset ring-gray-300 hover:bg-gray-100 focus:ring-gray-600',
        default => 'bg-indigo-600 text-white hover:bg-indigo-500 focus:ring-indigo-600',
    };
    
    // Size classes with standardized heights - matching input/select components
    $sizeClasses = match($size) {
        'xs' => 'px-2.5 py-1.5 text-xs h-8',
        'sm' => 'px-3 py-2 text-sm h-9',
        'md' => 'px-4 py-2.5 text-sm h-11',  // Same height as input/select
        'lg' => 'px-6 py-3 text-base h-12',
        'xl' => 'px-8 py-4 text-lg h-14',
        default => 'px-4 py-2.5 text-sm h-11',  // Same height as input/select
    };
    
    // Override disabled state for outline* and ghost variants
    if ($disabled && (str_starts_with($variant, 'outline') || $variant === 'ghost')) {
        // Neutralize rings, text color and remove hover/focus rings
        $variantClasses = preg_replace([
            '/ring-[a-z]+-\d+/',
            '/text-[a-z]+-\d+/',
            '/hover:bg-[a-z]+-\d+/',
            '/focus:ring-[a-z]+-\d+/'
        ], [
            'ring-gray-200',
            'text-gray-400',
            '',
            ''
        ], $variantClasses);
    }
    
    // Badge color variants
    $badgeColorClasses = match($badgeColor) {
        'red' => 'bg-red-500 text-white',
        'green' => 'bg-green-500 text-white',
        'blue' => 'bg-blue-500 text-white',
        'yellow' => 'bg-yellow-500 text-black',
        'indigo' => 'bg-indigo-500 text-white',
        'gray' => 'bg-gray-500 text-white',
        default => 'bg-red-500 text-white',
    };
    
    // Combine all classes
    $buttonClasses = $baseClasses . ' ' . $variantClasses . ' ' . $sizeClasses . ' ' . $class;
?>

<button 
    type="<?php echo e($type); ?>"
    <?php if($disabled): ?> disabled <?php endif; ?>
    <?php echo e($attributes->merge(['class' => $buttonClasses])); ?>

    <?php if($wireTarget): ?> wire:loading.attr="disabled" wire:target="<?php echo e($wireTarget); ?>" <?php endif; ?>
    <?php if($jsLoading): ?> onclick="this.disabled=true; this.querySelector('.js-loading').classList.remove('hidden'); this.querySelector('.js-normal').classList.add('hidden'); this.form?.submit();" <?php endif; ?>
>
    
    <!--[if BLOCK]><![endif]--><?php if($wireTarget): ?>
        <div wire:loading.remove wire:target="<?php echo e($wireTarget); ?>" class="flex items-center">
            <!--[if BLOCK]><![endif]--><?php if($leftIcon): ?>
                <i class="ph ph-<?php echo $leftIcon; ?> mr-2"></i>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'left'): ?>
                <span class="mr-2"><?php echo $icon; ?></span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            
            <span><?php echo e($slot); ?></span>
            
            <!--[if BLOCK]><![endif]--><?php if($badge): ?>
                <span class="ml-2 <?php echo e($badgeColorClasses); ?> text-xs font-bold rounded-full h-4 w-4 flex items-center justify-center min-w-4">
                    <?php echo e($badge); ?>

                </span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            
            <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'right'): ?>
                <span class="ml-2"><?php echo $icon; ?></span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($rightIcon): ?>
                <i class="ph ph-<?php echo $rightIcon; ?> ml-2"></i>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        
        <div wire:loading wire:target="<?php echo e($wireTarget); ?>" class="flex items-center justify-center">
            <?php if (isset($component)) { $__componentOriginal3048a2352e6e4266e4d8d3540589865a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3048a2352e6e4266e4d8d3540589865a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.basics.spinner','data' => ['size' => 'sm','class' => 'animate-spin']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('basics.spinner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['size' => 'sm','class' => 'animate-spin']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3048a2352e6e4266e4d8d3540589865a)): ?>
<?php $attributes = $__attributesOriginal3048a2352e6e4266e4d8d3540589865a; ?>
<?php unset($__attributesOriginal3048a2352e6e4266e4d8d3540589865a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3048a2352e6e4266e4d8d3540589865a)): ?>
<?php $component = $__componentOriginal3048a2352e6e4266e4d8d3540589865a; ?>
<?php unset($__componentOriginal3048a2352e6e4266e4d8d3540589865a); ?>
<?php endif; ?>
            <span class="ml-2"><?php echo e($loadingText ?? ''); ?></span>
        </div>
    <?php else: ?>
        
        <div class="js-normal <?php if($loading): ?> hidden <?php endif; ?> flex items-center">
            <!--[if BLOCK]><![endif]--><?php if($leftIcon): ?>
                <i class="ph ph-<?php echo $leftIcon; ?> mr-2"></i>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'left'): ?>
                <span class="mr-2"><?php echo $icon; ?></span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            
            <span><?php echo e($slot); ?></span>
            
            <!--[if BLOCK]><![endif]--><?php if($badge): ?>
                <span class="ml-2 <?php echo e($badgeColorClasses); ?> text-xs font-bold rounded-full h-4 w-4 flex items-center justify-center min-w-4">
                    <?php echo e($badge); ?>

                </span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            
            <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'right'): ?>
                <span class="ml-2"><?php echo $icon; ?></span>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($rightIcon): ?>
                <i class="ph ph-<?php echo $rightIcon; ?> ml-2"></i>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        
        <div class="js-loading <?php if(!$loading): ?> hidden <?php endif; ?> flex items-center justify-center">
            <svg class="animate-spin -ml-1 mr-3 h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
            <?php echo e($loadingText ?? 'Loading...'); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</button> <?php /**PATH D:\WORK\MAARIFA\ANGO\DESKTOP\V4\ango-desktop\resources\views/components/basics/button.blade.php ENDPATH**/ ?>