<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'variant' => 'primary',
    'size' => 'md',
    'href' => '#',
    'disabled' => false,
    'icon' => null,
    'iconPosition' => 'left',
    'class' => '',
    'badge' => null,
    'badgeColor' => 'red',
    // Backward compatibility props
    'leftIcon' => null,
    'rightIcon' => null,
    'target' => null,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'variant' => 'primary',
    'size' => 'md',
    'href' => '#',
    'disabled' => false,
    'icon' => null,
    'iconPosition' => 'left',
    'class' => '',
    'badge' => null,
    'badgeColor' => 'red',
    // Backward compatibility props
    'leftIcon' => null,
    'rightIcon' => null,
    'target' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    // Handle backward compatibility
    if ($leftIcon) {
        $icon = '<i class="ph ph-' . $leftIcon . '"></i>';
        $iconPosition = 'left';
    } elseif ($rightIcon) {
        $icon = '<i class="ph ph-' . $rightIcon . '"></i>';
        $iconPosition = 'right';
    }
    
    // Check if it's an external URL (starts with http:// or https://)
    $isExternal = !empty($href) && (str_starts_with($href, 'http://') || str_starts_with($href, 'https://'));
    
    // Convert old variant names to new ones
    $variant = match($variant) {
        'outlined' => 'outline',
        'filled' => 'primary',
        default => $variant,
    };
    
    // Base button-link classes - matching button component design
    $baseClasses = 'inline-flex items-center justify-center font-semibold rounded-lg shadow-sm transition-all duration-200 focus:ring-1 focus:ring-inset no-underline';
    
    // Variant classes with matching focus colors - same as button component
    $variantClasses = match($variant) {
        'primary' => 'bg-indigo-600 text-white hover:bg-indigo-500 focus:ring-indigo-600',
        'secondary' => 'bg-gray-600 text-white hover:bg-gray-500 focus:ring-gray-600',
        'success' => 'bg-green-600 text-white hover:bg-green-500 focus:ring-green-600',
        'danger' => 'bg-red-600 text-white hover:bg-red-500 focus:ring-red-600',
        'warning' => 'bg-yellow-600 text-white hover:bg-yellow-500 focus:ring-yellow-600',
        'info' => 'bg-blue-600 text-white hover:bg-blue-500 focus:ring-blue-600',
        'outline' => 'bg-transparent text-indigo-600 ring-1 ring-inset ring-indigo-600 hover:bg-indigo-50 focus:ring-indigo-600',
        'ghost' => 'bg-transparent text-gray-700 ring-1 ring-inset ring-gray-300 hover:bg-gray-100 focus:ring-gray-600',
        default => 'bg-indigo-600 text-white hover:bg-indigo-500 focus:ring-indigo-600',
    };
    
    // Size classes with standardized heights - matching button component
    $sizeClasses = match($size) {
        'xs' => 'px-2.5 py-1.5 text-xs h-8',
        'sm' => 'px-3 py-2 text-sm h-9',
        'md' => 'px-4 py-2.5 text-sm h-11',  // Same height as input/select
        'lg' => 'px-6 py-3 text-base h-12',
        'xl' => 'px-8 py-4 text-lg h-14',
        default => 'px-4 py-2.5 text-sm h-11',  // Same height as input/select
    };
    
    // Handle disabled state
    if ($disabled) {
        $baseClasses .= ' opacity-60 cursor-not-allowed pointer-events-none bg-gray-100 text-gray-500';
        // Override disabled state for outline and ghost variants
        if (in_array($variant, ['outline', 'ghost'])) {
            $variantClasses = str_replace(['ring-indigo-600', 'ring-gray-300'], 'ring-gray-200', $variantClasses);
            // Remove focus ring for disabled state
            $variantClasses = preg_replace('/focus:ring-\w+-\d+/', '', $variantClasses);
        }
    }
    
    // Badge color variants
    $badgeColorClasses = match($badgeColor) {
        'red' => 'bg-red-500 text-white',
        'green' => 'bg-green-500 text-white',
        'blue' => 'bg-blue-500 text-white',
        'yellow' => 'bg-yellow-500 text-black',
        'indigo' => 'bg-indigo-500 text-white',
        'gray' => 'bg-gray-500 text-white',
        default => 'bg-red-500 text-white',
    };
    
    // Combine all classes
    $linkClasses = $baseClasses . ' ' . $variantClasses . ' ' . $sizeClasses . ' ' . $class;
?>

<a 
    href="<?php echo e($disabled ? '#' : $href); ?>"
    <?php if($disabled): ?> tabindex="-1" aria-disabled="true" <?php endif; ?>
    <?php echo e($attributes->merge(['class' => $linkClasses])); ?> 
    <?php echo e($target ? 'target="_blank"' : ''); ?>

    <?php if(!$isExternal): ?> wire:navigate <?php endif; ?> wire:navigate>
    <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'left'): ?>
        <span class="mr-2"><?php echo $icon; ?></span>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    
    <span><?php echo e($slot); ?></span>
    
    <!--[if BLOCK]><![endif]--><?php if($badge): ?>
        <span class="ml-2 <?php echo e($badgeColorClasses); ?> text-xs font-bold rounded-full h-4 w-4 flex items-center justify-center min-w-4">
            <?php echo e($badge); ?>

        </span>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    
    <!--[if BLOCK]><![endif]--><?php if($icon && $iconPosition === 'right'): ?>
        <span class="ml-2"><?php echo $icon; ?></span>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</a>
<?php /**PATH D:\WORK\MAARIFA\ANGO\DESKTOP\V4\ango-desktop\resources\views/components/basics/button-link.blade.php ENDPATH**/ ?>